﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

#include <nn/cec/cec_Api.h>

extern nn::os::SystemEventType s_CecSystemEvent;

struct ThreadData
{
    nn::os::EventType syncEvent;
    nn::Result result;
};

const int s_PowerStateChangingRetries = 5;
const int s_PowerStateChangingRetryDelay = 15000;
const int s_PowerStateTimeoutMs = 60000;

const char* BusEventToString(nn::cec::BusEventType busEvent);
const char* PowerStateToString(nn::cec::PowerState powerState);
const char* ConnectionStateToString(nn::cec::ConnectionState connectionState);

bool WaitSystemEventWithTimeout(int timeoutMs, nn::cec::BusEventType busEvent, bool fail = true);

void CheckCECBusType(nn::cec::BusEventType expectedEvent);
nn::cec::BusEventType GetCECBusType();

void SuspendCECManager(bool isStarted);
void ResumeCECManager(bool isStarted);

bool WaitForPowerState(nn::cec::PowerState targetState, int timeoutMs, bool fail = true);
nn::cec::PowerState GetPowerState(int timeoutMs = 5000);

void TurnOffTV(int timeout = s_PowerStateTimeoutMs);
void TurnOnTV(int maxRetries = s_PowerStateChangingRetries, int retryDelay = s_PowerStateChangingRetryDelay, int timeout = s_PowerStateTimeoutMs);

void CallCancelledRestartManager(void*) NN_NOEXCEPT;
void CallCancelledIsTvResponsive(void*) NN_NOEXCEPT;
void CallCancelledPerformOneTouchPlay(void*) NN_NOEXCEPT;
void CallCancelledGetTvPowerState(void*) NN_NOEXCEPT;

void CallAndCancelFunctionFunc(nn::os::ThreadFunction func, int delayUs, int timeoutMs);

#define CallAndCancelFunction(func, delayUs, timeoutMs)                                             \
NN_LOG("Call/Cancelling %s with delay %i us and timeout %i ms...\n", #func, delayUs, timeoutMs);    \
CallAndCancelFunctionFunc(func, delayUs, timeoutMs);
