<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Resets the HDMI Switcher

    .DESCRIPTION
        Resets the HDMI Switcher to the default EDID (output) and switches the input to port 1.
#>

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

. "${scriptDirectoryPath}\Common.ps1"

###############################################################################################
Write-Host "Resetting EDID to output..."
Write-HDMI-Switcher "s 1"
Write-Host "Switching HDMI input to port 1..."
Write-HDMI-Switcher "#set_edid output 1 input 1"

###############################################################################################
Write-Host "Setting display to 1080p with no underscan..."

$ret = & $RunOnTargetExe "${scriptRootPath}\Tests\Outputs\NX-NXFP2-a64\Tests\DisplayResolution\Develop\DisplayResolution.nsp" -- -resolution 1080 -underscan 0 -update_display -update_underscan -update_nand -no_run
