﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nn/nn_Log.h>
#include <nn/vi/vi_Display.h>
#include <nn/vi/vi_LibMinimum.h>
#include <nn/vi/vi_DisplayEvents.h>
#include <nn/omm/omm_Api.h>

namespace
{
    class Topology : public ::testing::Test
    {
        public:
            Topology() NN_NOEXCEPT
            {
                nn::vi::InitializeMinimum();
                nn::omm::Initialize();
            }

            virtual ~Topology() NN_NOEXCEPT
            {
                nn::omm::Finalize();
                nn::vi::FinalizeMinimum();
            }
    };
}

TEST_F(Topology, IsExternalDisplayConnected)
{
    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "External"));

    nn::vi::HotplugState hotplug;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayHotplugState(&hotplug, pDisplay));

    ASSERT_EQ(nn::vi::HotplugState_Connected, hotplug);
}

TEST_F(Topology, IsExternalDisplayDisconnected)
{
    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "External"));

    nn::vi::HotplugState hotplug;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayHotplugState(&hotplug, pDisplay));

    ASSERT_EQ(nn::vi::HotplugState_Disconnected, hotplug);
}

TEST_F(Topology, IsCradleConnected)
{
    ASSERT_EQ(nn::omm::CradleStatus::Mountable, nn::omm::GetCradleStatus());

    std::uint32_t pdcH;
    std::uint32_t pdcA;
    std::uint32_t mcu;
    std::uint32_t dp2Hdmi;

    NNT_ASSERT_RESULT_SUCCESS(nn::omm::GetCradleFwVersion(&pdcH, &pdcA, &mcu, &dp2Hdmi));

    NN_LOG("PDCH Version    : 0x%08X\n", pdcH);
    NN_LOG("PDCA Version    : 0x%08X\n", pdcA);
    NN_LOG("MCU Version     : 0x%08X\n", mcu);
    NN_LOG("DP2HDMI Version : 0x%08X\n", dp2Hdmi);
}

TEST_F(Topology, IsCradleDisconnected)
{
    ASSERT_NE(nn::omm::CradleStatus::Mountable, nn::omm::GetCradleStatus());
}
