﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// Based on sample code from https://www.w3.org/TR/PNG/#D-CRCAppendix
struct CRC
{
    CRC()
    {
        for (int i = 0; i < CrcTableSize; ++i)
        {
            unsigned int val = i;
            for (int j = 0; j < 8; ++j)
            {
                if (val & 1)
                {
                    val = 0xEDB88320 ^ (val >> 1);
                }
                else
                {
                    val = val >> 1;
                }
            }
            crcTable[i] = val;
        }
    }

    static const int        CrcTableSize = 256;
    unsigned int     crcTable[CrcTableSize];

} g_crc;

unsigned int ComputeCRC(unsigned char* buffer, int len, int crc)
{
    for (int i = 0; i < len; ++i)
    {
        crc = g_crc.crcTable[(crc ^ buffer[i]) & 0xFF] ^ (crc >> 8);
    }

    return crc ^ 0xFFFFFFFF;
}
