﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <memory>
#include <numeric>

#include <nn/nn_Macro.h>
#include <nn/crypto/crypto_Sha256Generator.h>
#include <nn/os/os_Random.h>

namespace
{
    class Object
    {
    public:
        ~Object() NN_NOEXCEPT
        {
            const size_t DataSize = 128 << 20; // 128 MB
            std::unique_ptr<nn::Bit8, decltype(&std::free)> randomData(
                static_cast<nn::Bit8*>(std::malloc(DataSize)), std::free);

            nn::crypto::Sha256Generator generator;
            generator.Initialize();

            for (int i = 0; i < std::numeric_limits<int>::max(); i++) // 警告されるので無限ループにしない。
            {
                nn::os::GenerateRandomBytes(randomData.get(), DataSize);
                generator.Update(randomData.get(), DataSize);
            }
        }
    };
}

extern "C" void nnMain()
{
    Object object;
}
