﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nn/nn_Log.h>
#include <nn/util/util_FormatString.h>

TEST(LogFormat, ColoringForeground)
{
    const int intervalY = 4;
    const int intervalX = 2;

    const int lineLength = ((sizeof("\033[38;2;255;255;255mX\033[m") - 1) * (256 / intervalX));
    static char line[lineLength + 1];

    for (int y = 0; y < 256; y += intervalY)
    {
        int offset = 0;

        for (int x = 0; x < 256; x += intervalX)
        {
            const int r = 255 - y;
            const int g = x;
            const int b = ((255 - x) * y) / 255;

            offset += nn::util::SNPrintf(line + offset, sizeof(line) - offset, "\033[38;2;%d;%d;%dmX\033[m", r, g, b);
            ASSERT_LE(offset, lineLength);
        }

        NN_LOG("%.*s\n", offset, line);
    }
}

TEST(LogFormat, ColoringBackground)
{
    const int intervalY = 4;
    const int intervalX = 2;

    const int lineLength = ((sizeof("\033[48;2;255;255;255m \033[m") - 1) * (256 / intervalX));
    static char line[lineLength + 1];

    for (int y = 0; y < 256; y += intervalY)
    {
        int offset = 0;

        for (int x = 0; x < 256; x += intervalX)
        {
            const int r = 255 - y;
            const int g = x;
            const int b = ((255 - x) * y) / 255;

            offset += nn::util::SNPrintf(line + offset, sizeof(line) - offset, "\033[48;2;%d;%d;%dm \033[m", r, g, b);
            ASSERT_LE(offset, lineLength);
        }

        NN_LOG("%.*s\n", offset, line);
    }
}
