﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>

#include <nn/ddsf/ddsf_CastSafe.h>

#include <nnt/nntest.h>

namespace {

    class TypeTagBase: public nn::ddsf::ICastSafe
    {
        NN_DDSF_CAST_SAFE_DECL;
    };
    NN_DETAIL_DDSF_CAST_SAFE_DEFINE_ROOT(TypeTagBase);

    class TypeTagDerived1 : public TypeTagBase
    {
        NN_DDSF_CAST_SAFE_DECL;
    };
    NN_DDSF_CAST_SAFE_DEFINE(TypeTagDerived1, TypeTagBase);

    class TypeTagDerived11 : public TypeTagDerived1
    {
        NN_DDSF_CAST_SAFE_DECL;
    };
    NN_DDSF_CAST_SAFE_DEFINE(TypeTagDerived11, TypeTagDerived1);

    class TypeTagDerived13_Ill : public TypeTagDerived1
    {
        // 意図的にサボる
        // NN_DDSF_CAST_SAFE_DECL;
    };
    // NN_DDSF_CAST_SAFE_DEFINE(TypeTagDerived13_Ill, TypeTagDerived1);

    class TypeTagDerived2 : public TypeTagBase
    {
        NN_DDSF_CAST_SAFE_DECL;
    };
    NN_DDSF_CAST_SAFE_DEFINE(TypeTagDerived2, TypeTagBase);

    class TypeTagDerived21 : public TypeTagDerived2
    {
        NN_DDSF_CAST_SAFE_DECL;
    };
    NN_DDSF_CAST_SAFE_DEFINE(TypeTagDerived21, TypeTagDerived2);

    class TypeTagDerived22 : public TypeTagDerived2
    {
        NN_DDSF_CAST_SAFE_DECL;
    };
    NN_DDSF_CAST_SAFE_DEFINE(TypeTagDerived22, TypeTagDerived2);

}

TEST(SafeCast, IsCastable)
{
    TypeTagBase instBase;
    TypeTagDerived1 instDerived1;
    TypeTagDerived11 instDerived11;
    TypeTagDerived13_Ill instDerived13_Ill;
    TypeTagDerived2 instDerived2;
    TypeTagDerived21 instDerived21;
    TypeTagDerived22 instDerived22;

    //
    // キャスト可能か判定が正しくできるかのテスト
    //

    EXPECT_TRUE (instBase.IsCastableTo<TypeTagBase>());
    EXPECT_FALSE(instBase.IsCastableTo<TypeTagDerived1>());
    EXPECT_FALSE(instBase.IsCastableTo<TypeTagDerived11>());
    EXPECT_FALSE(instBase.IsCastableTo<TypeTagDerived13_Ill>());
    EXPECT_FALSE(instBase.IsCastableTo<TypeTagDerived2>());
    EXPECT_FALSE(instBase.IsCastableTo<TypeTagDerived21>());
    EXPECT_FALSE(instBase.IsCastableTo<TypeTagDerived22>());

    EXPECT_TRUE (instDerived1.IsCastableTo<TypeTagBase>());
    EXPECT_TRUE (instDerived1.IsCastableTo<TypeTagDerived1>());
    EXPECT_FALSE(instDerived1.IsCastableTo<TypeTagDerived11>());
    EXPECT_TRUE (instDerived1.IsCastableTo<TypeTagDerived13_Ill>()); // TypeTagDerived13_Ill は NN_DDSF_CAST_SAFE_DECL をさぼっているので 型情報が直上の親と同等扱いで、これが実際に反して成功してしまう
    EXPECT_FALSE(instDerived1.IsCastableTo<TypeTagDerived2>());
    EXPECT_FALSE(instDerived1.IsCastableTo<TypeTagDerived21>());
    EXPECT_FALSE(instDerived1.IsCastableTo<TypeTagDerived22>());

    EXPECT_TRUE (instDerived11.IsCastableTo<TypeTagBase>());
    EXPECT_TRUE (instDerived11.IsCastableTo<TypeTagDerived1>());
    EXPECT_TRUE (instDerived11.IsCastableTo<TypeTagDerived11>());
    EXPECT_TRUE (instDerived11.IsCastableTo<TypeTagDerived13_Ill>()); // TypeTagDerived13_Ill は NN_DDSF_CAST_SAFE_DECL をさぼっているので 型情報が直上の親と同等扱いで、これが実際に反して成功してしまう
    EXPECT_FALSE(instDerived11.IsCastableTo<TypeTagDerived2>());
    EXPECT_FALSE(instDerived11.IsCastableTo<TypeTagDerived21>());
    EXPECT_FALSE(instDerived11.IsCastableTo<TypeTagDerived22>());

    EXPECT_TRUE (instDerived13_Ill.IsCastableTo<TypeTagBase>());
    EXPECT_TRUE (instDerived13_Ill.IsCastableTo<TypeTagDerived1>());
    EXPECT_FALSE(instDerived13_Ill.IsCastableTo<TypeTagDerived11>());
    EXPECT_TRUE (instDerived13_Ill.IsCastableTo<TypeTagDerived13_Ill>());
    EXPECT_FALSE(instDerived13_Ill.IsCastableTo<TypeTagDerived2>());
    EXPECT_FALSE(instDerived13_Ill.IsCastableTo<TypeTagDerived21>());
    EXPECT_FALSE(instDerived13_Ill.IsCastableTo<TypeTagDerived22>());

    EXPECT_TRUE (instDerived2.IsCastableTo<TypeTagBase>());
    EXPECT_FALSE(instDerived2.IsCastableTo<TypeTagDerived1>());
    EXPECT_FALSE(instDerived2.IsCastableTo<TypeTagDerived11>());
    EXPECT_FALSE(instDerived2.IsCastableTo<TypeTagDerived13_Ill>());
    EXPECT_TRUE (instDerived2.IsCastableTo<TypeTagDerived2>());
    EXPECT_FALSE(instDerived2.IsCastableTo<TypeTagDerived21>());
    EXPECT_FALSE(instDerived2.IsCastableTo<TypeTagDerived22>());

    EXPECT_TRUE (instDerived21.IsCastableTo<TypeTagBase>());
    EXPECT_FALSE(instDerived21.IsCastableTo<TypeTagDerived1>());
    EXPECT_FALSE(instDerived21.IsCastableTo<TypeTagDerived11>());
    EXPECT_FALSE(instDerived21.IsCastableTo<TypeTagDerived13_Ill>());
    EXPECT_TRUE (instDerived21.IsCastableTo<TypeTagDerived2>());
    EXPECT_TRUE (instDerived21.IsCastableTo<TypeTagDerived21>());
    EXPECT_FALSE(instDerived21.IsCastableTo<TypeTagDerived22>());

    EXPECT_TRUE (instDerived22.IsCastableTo<TypeTagBase>());
    EXPECT_FALSE(instDerived22.IsCastableTo<TypeTagDerived1>());
    EXPECT_FALSE(instDerived22.IsCastableTo<TypeTagDerived11>());
    EXPECT_FALSE(instDerived22.IsCastableTo<TypeTagDerived13_Ill>());
    EXPECT_TRUE (instDerived22.IsCastableTo<TypeTagDerived2>());
    EXPECT_FALSE(instDerived22.IsCastableTo<TypeTagDerived21>());
    EXPECT_TRUE (instDerived22.IsCastableTo<TypeTagDerived22>());

    //
    // 基底クラスの参照（またはポインタ）の状態からでも同じ結果になる
    //

    TypeTagBase* pBase = &instBase;
    TypeTagBase* pDerived1AsBase = &instDerived1;
    TypeTagBase* pDerived11AsBase = &instDerived11;
    TypeTagBase* pDerived13AsBase_Ill = &instDerived13_Ill;
    TypeTagBase* pDerived2AsBase = &instDerived2;
    TypeTagBase* pDerived21AsBase = &instDerived21;
    TypeTagBase* pDerived22AsBase = &instDerived22;

    EXPECT_TRUE (pBase->IsCastableTo<TypeTagBase>());
    EXPECT_FALSE(pBase->IsCastableTo<TypeTagDerived1>());
    EXPECT_FALSE(pBase->IsCastableTo<TypeTagDerived11>());
    EXPECT_FALSE(pBase->IsCastableTo<TypeTagDerived13_Ill>());
    EXPECT_FALSE(pBase->IsCastableTo<TypeTagDerived2>());
    EXPECT_FALSE(pBase->IsCastableTo<TypeTagDerived21>());
    EXPECT_FALSE(pBase->IsCastableTo<TypeTagDerived22>());

    EXPECT_TRUE (pDerived1AsBase->IsCastableTo<TypeTagBase>());
    EXPECT_TRUE (pDerived1AsBase->IsCastableTo<TypeTagDerived1>());
    EXPECT_FALSE(pDerived1AsBase->IsCastableTo<TypeTagDerived11>());
    EXPECT_TRUE (pDerived1AsBase->IsCastableTo<TypeTagDerived13_Ill>()); // TypeTagDerived13_Ill は NN_DDSF_CAST_SAFE_DECL をさぼっているので 型情報が直上の親と同等扱いで、これが実際に反して成功してしまう
    EXPECT_FALSE(pDerived1AsBase->IsCastableTo<TypeTagDerived2>());
    EXPECT_FALSE(pDerived1AsBase->IsCastableTo<TypeTagDerived21>());
    EXPECT_FALSE(pDerived1AsBase->IsCastableTo<TypeTagDerived22>());

    EXPECT_TRUE (pDerived11AsBase->IsCastableTo<TypeTagBase>());
    EXPECT_TRUE (pDerived11AsBase->IsCastableTo<TypeTagDerived1>());
    EXPECT_TRUE (pDerived11AsBase->IsCastableTo<TypeTagDerived11>());
    EXPECT_TRUE (pDerived11AsBase->IsCastableTo<TypeTagDerived13_Ill>()); // TypeTagDerived13_Ill は NN_DDSF_CAST_SAFE_DECL をさぼっているので 型情報が直上の親と同等扱いで、これが実際に反して成功してしまう
    EXPECT_FALSE(pDerived11AsBase->IsCastableTo<TypeTagDerived2>());
    EXPECT_FALSE(pDerived11AsBase->IsCastableTo<TypeTagDerived21>());
    EXPECT_FALSE(pDerived11AsBase->IsCastableTo<TypeTagDerived22>());

    EXPECT_TRUE (pDerived13AsBase_Ill->IsCastableTo<TypeTagBase>());
    EXPECT_TRUE (pDerived13AsBase_Ill->IsCastableTo<TypeTagDerived1>());
    EXPECT_FALSE(pDerived13AsBase_Ill->IsCastableTo<TypeTagDerived11>());
    EXPECT_TRUE (pDerived13AsBase_Ill->IsCastableTo<TypeTagDerived13_Ill>());
    EXPECT_FALSE(pDerived13AsBase_Ill->IsCastableTo<TypeTagDerived2>());
    EXPECT_FALSE(pDerived13AsBase_Ill->IsCastableTo<TypeTagDerived21>());
    EXPECT_FALSE(pDerived13AsBase_Ill->IsCastableTo<TypeTagDerived22>());

    EXPECT_TRUE (pDerived2AsBase->IsCastableTo<TypeTagBase>());
    EXPECT_FALSE(pDerived2AsBase->IsCastableTo<TypeTagDerived1>());
    EXPECT_FALSE(pDerived2AsBase->IsCastableTo<TypeTagDerived11>());
    EXPECT_FALSE(pDerived2AsBase->IsCastableTo<TypeTagDerived13_Ill>());
    EXPECT_TRUE (pDerived2AsBase->IsCastableTo<TypeTagDerived2>());
    EXPECT_FALSE(pDerived2AsBase->IsCastableTo<TypeTagDerived21>());
    EXPECT_FALSE(pDerived2AsBase->IsCastableTo<TypeTagDerived22>());

    EXPECT_TRUE (pDerived21AsBase->IsCastableTo<TypeTagBase>());
    EXPECT_FALSE(pDerived21AsBase->IsCastableTo<TypeTagDerived1>());
    EXPECT_FALSE(pDerived21AsBase->IsCastableTo<TypeTagDerived11>());
    EXPECT_FALSE(pDerived21AsBase->IsCastableTo<TypeTagDerived13_Ill>());
    EXPECT_TRUE (pDerived21AsBase->IsCastableTo<TypeTagDerived2>());
    EXPECT_TRUE (pDerived21AsBase->IsCastableTo<TypeTagDerived21>());
    EXPECT_FALSE(pDerived21AsBase->IsCastableTo<TypeTagDerived22>());

    EXPECT_TRUE (pDerived22AsBase->IsCastableTo<TypeTagBase>());
    EXPECT_FALSE(pDerived22AsBase->IsCastableTo<TypeTagDerived1>());
    EXPECT_FALSE(pDerived22AsBase->IsCastableTo<TypeTagDerived11>());
    EXPECT_FALSE(pDerived22AsBase->IsCastableTo<TypeTagDerived13_Ill>());
    EXPECT_TRUE (pDerived22AsBase->IsCastableTo<TypeTagDerived2>());
    EXPECT_FALSE(pDerived22AsBase->IsCastableTo<TypeTagDerived21>());
    EXPECT_TRUE (pDerived22AsBase->IsCastableTo<TypeTagDerived22>());
} // NOLINT(impl/function_size)

TEST(SafeCast, SafeCastTo)
{
    TypeTagBase instBase;
    TypeTagDerived11 instDerived11;
    TypeTagDerived2 instDerived2;
    TypeTagDerived21 instDerived21;

    //
    // 継承関係に対応して正しくアサートが働く
    //

    (void)instBase.SafeCastTo<TypeTagBase>(); // OK
    (void)instBase.SafeCastToPointer<TypeTagBase>(); // OK
    EXPECT_DEATH_IF_SUPPORTED((void)instBase.SafeCastTo<TypeTagDerived11>(), "");
    EXPECT_DEATH_IF_SUPPORTED((void)instBase.SafeCastToPointer<TypeTagDerived11>(), "");
    EXPECT_DEATH_IF_SUPPORTED((void)instBase.SafeCastTo<TypeTagDerived2>(), "");
    EXPECT_DEATH_IF_SUPPORTED((void)instBase.SafeCastToPointer<TypeTagDerived2>(), "");
    EXPECT_DEATH_IF_SUPPORTED((void)instBase.SafeCastTo<TypeTagDerived21>(), "");
    EXPECT_DEATH_IF_SUPPORTED((void)instBase.SafeCastToPointer<TypeTagDerived21>(), "");

    (void)instDerived11.SafeCastTo<TypeTagBase>(); // OK
    (void)instDerived11.SafeCastToPointer<TypeTagBase>(); // OK
    (void)instDerived11.SafeCastTo<TypeTagDerived11>(); // OK
    (void)instDerived11.SafeCastToPointer<TypeTagDerived11>(); // OK
    EXPECT_DEATH_IF_SUPPORTED((void)instDerived11.SafeCastTo<TypeTagDerived2>(), "");
    EXPECT_DEATH_IF_SUPPORTED((void)instDerived11.SafeCastToPointer<TypeTagDerived2>(), "");
    EXPECT_DEATH_IF_SUPPORTED((void)instDerived11.SafeCastTo<TypeTagDerived21>(), "");
    EXPECT_DEATH_IF_SUPPORTED((void)instDerived11.SafeCastToPointer<TypeTagDerived21>(), "");

    (void)instDerived2.SafeCastTo<TypeTagBase>(); // OK
    (void)instDerived2.SafeCastToPointer<TypeTagBase>(); // OK
    EXPECT_DEATH_IF_SUPPORTED((void)instDerived2.SafeCastTo<TypeTagDerived11>(), "");
    EXPECT_DEATH_IF_SUPPORTED((void)instDerived2.SafeCastToPointer<TypeTagDerived11>(), "");
    (void)instDerived2.SafeCastTo<TypeTagDerived2>(); // OK
    (void)instDerived2.SafeCastToPointer<TypeTagDerived2>(); // OK
    EXPECT_DEATH_IF_SUPPORTED((void)instDerived2.SafeCastTo<TypeTagDerived21>(), "");
    EXPECT_DEATH_IF_SUPPORTED((void)instDerived2.SafeCastToPointer<TypeTagDerived21>(), "");

    (void)instDerived21.SafeCastTo<TypeTagBase>(); // OK
    (void)instDerived21.SafeCastToPointer<TypeTagBase>(); // OK
    EXPECT_DEATH_IF_SUPPORTED((void)instDerived2.SafeCastTo<TypeTagDerived11>(), "");
    EXPECT_DEATH_IF_SUPPORTED((void)instDerived2.SafeCastToPointer<TypeTagDerived11>(), "");
    (void)instDerived21.SafeCastTo<TypeTagDerived2>(); // OK
    (void)instDerived21.SafeCastToPointer<TypeTagDerived2>(); // OK
    (void)instDerived21.SafeCastTo<TypeTagDerived21>(); // OK
    (void)instDerived21.SafeCastToPointer<TypeTagDerived21>(); // OK

    //
    // 基底クラスの参照（またはポインタ）の状態からでも同じ結果になる
    //

    TypeTagBase* pDerived11AsBase = &instDerived11;
    TypeTagBase* pDerived21AsBase = &instDerived21;

    (void)pDerived11AsBase->SafeCastTo<TypeTagBase>(); // OK
    (void)pDerived11AsBase->SafeCastToPointer<TypeTagBase>(); // OK
    (void)pDerived11AsBase->SafeCastTo<TypeTagDerived11>(); // OK
    (void)pDerived11AsBase->SafeCastToPointer<TypeTagDerived11>(); // OK
    EXPECT_DEATH_IF_SUPPORTED((void)pDerived11AsBase->SafeCastTo<TypeTagDerived2>(), "");
    EXPECT_DEATH_IF_SUPPORTED((void)pDerived11AsBase->SafeCastToPointer<TypeTagDerived2>(), "");
    EXPECT_DEATH_IF_SUPPORTED((void)pDerived11AsBase->SafeCastTo<TypeTagDerived21>(), "");
    EXPECT_DEATH_IF_SUPPORTED((void)pDerived11AsBase->SafeCastToPointer<TypeTagDerived21>(), "");

    (void)pDerived21AsBase->SafeCastTo<TypeTagBase>(); // OK
    (void)pDerived21AsBase->SafeCastToPointer<TypeTagBase>(); // OK
    EXPECT_DEATH_IF_SUPPORTED((void)pDerived21AsBase->SafeCastTo<TypeTagDerived11>(), "");
    EXPECT_DEATH_IF_SUPPORTED((void)pDerived21AsBase->SafeCastToPointer<TypeTagDerived11>(), "");
    (void)pDerived21AsBase->SafeCastTo<TypeTagDerived2>(); // OK
    (void)pDerived21AsBase->SafeCastToPointer<TypeTagDerived2>(); // OK
    (void)pDerived21AsBase->SafeCastTo<TypeTagDerived21>(); // OK
    (void)pDerived21AsBase->SafeCastToPointer<TypeTagDerived21>(); // OK
    EXPECT_DEATH_IF_SUPPORTED((void)pDerived21AsBase->SafeCastTo<TypeTagDerived22>(), "");
    EXPECT_DEATH_IF_SUPPORTED((void)pDerived21AsBase->SafeCastToPointer<TypeTagDerived22>(), "");

    //
    // const / volatile 追加キャストができる
    //

    (void)instDerived21.SafeCastTo<const TypeTagDerived2>(); // OK
    (void)instDerived21.SafeCastToPointer<const TypeTagDerived2>(); // OK
    (void)instDerived21.SafeCastTo<volatile const TypeTagDerived2>(); // OK
    (void)instDerived21.SafeCastToPointer<volatile const TypeTagDerived2>(); // OK
}

// API リファレンスに記載したサンプルコード通りの処理の挙動を確認するもの
TEST(SafeCast, ApiRefSampleCode)
{
    TypeTagBase base;
    TypeTagDerived1 derived;

    TypeTagBase* pBase = &base;
    EXPECT_FALSE(pBase->IsCastableTo<TypeTagDerived1>());
    EXPECT_FALSE(pBase->IsCastableTo<TypeTagDerived2>());

    TypeTagDerived1* pDerived = &derived;
    EXPECT_TRUE(pDerived->IsCastableTo<TypeTagBase>());
    EXPECT_TRUE(pDerived->IsCastableTo<TypeTagDerived1>());
    EXPECT_FALSE(pDerived->IsCastableTo<TypeTagDerived2>());

    TypeTagBase* pDerivedAsBase = &derived;
    EXPECT_TRUE(pDerivedAsBase->IsCastableTo<TypeTagBase>());
    EXPECT_TRUE(pDerivedAsBase->IsCastableTo<TypeTagDerived1>());
    EXPECT_FALSE(pDerivedAsBase->IsCastableTo<TypeTagDerived2>());
}
