﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  メモリバリア API のテスト
//---------------------------------------------------------------------------

#include <cstring>

#include "../Common/test_Pragma.h"

#include <nn/TargetConfigs/build_Compiler.h>
#include <nn/nn_SdkText.h>

#include <nnt/nntest.h>

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/dd.h>

namespace nnt { namespace dd { namespace memoryBarrier {

// API が呼び出せるかどうかのみのテスト
TEST(MemoryBarrier, CallTest)
{
    nn::dd::EnsureMemoryAccess();
}

// メモリバリアのパフォーマンスを計測
TEST(MemoryBarrier, PerformanceMeasurement)
{
    const int loopNumber = 10000;
    nn::os::Tick startTick;
    nn::os::Tick duration;

    // メモリ書き込みのみ
    startTick = nn::os::GetSystemTick();
    for (int i=0; i<loopNumber; i++)
    {
        nn::dd::EnsureMemoryAccess();
    }
    duration = nn::os::GetSystemTick() - startTick;
    NN_LOG(NN_TEXT("メモリバリア %d 回 = %lld us\n"), loopNumber, nn::os::ConvertToTimeSpan( duration ).GetMicroSeconds());
}

}}} // namespace nnt::dd::memoryBarrier
