﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------
//  デバイスアドレス空間の API のテスト
//-----------------------------------------------------------------------------

#include "../Common/test_Pragma.h"

#include <nn/TargetConfigs/build_Base.h>
#include <nn/nn_SdkText.h>

#include <nnt/nntest.h>

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/dd.h>
#include <nn/dd/dd_Result.h>

#if defined(NN_BUILD_CONFIG_OS_HORIZON) && \
    (defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1) || \
     defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || \
     defined(NN_BUILD_CONFIG_SOC_TEGRA_X1))

    //-------------------------------------------------------------------------
    // デバイスアドレス空間をサポートしているボードでは、
    // このファイルの中ではテストを定義しない。
    //-------------------------------------------------------------------------

#else

    //-------------------------------------------------------------------------
    // このファイルでは、デバイスアドレス空間をサポートしていない環境において、
    // nn::dd::ResultNotSupported() が正しく返るかのテストのみ行なう。
    //-------------------------------------------------------------------------

namespace nnt { namespace dd { namespace deviceAddressSpace {

//-----------------------------------------------------------------------------
// nn::dd::CreateDeviceAddressSpace() にて ResultNotSupported() が返るか
//
TEST(DeviceAddressSpace, CreateDeviceAddressSpaceTest)
{
    NN_LOG(NN_TEXT("CreateDeviceAddressSpace() にて ResultNotSupported() が返るか "));

    // とりあえず CreateDeviceAddressSpace() を呼ぶ。サイズは適当。
    nn::dd::DeviceAddressSpaceType   device;

    auto result = nn::dd::CreateDeviceAddressSpace(&device, 0x1000);
    if (nn::dd::ResultNotSupported::Includes(result))
    {
        NN_LOG("... OK\n");
        SUCCEED();
    }
    else
    {
        NN_LOG("... NG\n");
        FAIL();
    }
}

//-----------------------------------------------------------------------------

}}} // namespace nnt::dd::deviceAddressSpace

#endif

