﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdarg>
#include <nn/cstd/cstd_CStdArg.h>
#include <nn/nn_Common.h>
#include <nnt/nntest.h>

// 引数として渡された va_list をコピーできることのテスト
void TestVaCopyVaListParameter(std::va_list va1)
{
    std::va_list va2;
    NN_CSTD_VA_COPY(va2, va1);

    // コピー元を変更しておく
    va_arg(va1, int);
    va_arg(va1, int);
    va_arg(va1, int);

    // コピーされた va_list から引数を取得できる
    // また、コピー元の変更の影響を受けていない
    ASSERT_EQ(1, va_arg(va2, int));
    ASSERT_EQ(2, va_arg(va2, int));
    ASSERT_EQ(3, va_arg(va2, int));

    va_end(va2);
}

void CallTestVaCopyVaListParameter(int dummy, ...)
{
    std::va_list va;
    va_start(va, dummy);
    TestVaCopyVaListParameter(va);
    va_end(va);
}

// 関数内で定義した va_list の変数をコピーできることのテスト
void TestVaCopyVaListVariable(int dummy, ...)
{
    std::va_list va1;
    va_start(va1, dummy);

    std::va_list va2;
    NN_CSTD_VA_COPY(va2, va1);

    // コピー元を変更しておく
    va_arg(va1, int);
    va_arg(va1, int);
    va_arg(va1, int);

    // コピーされた va_list から引数を取得できる
    // また、コピー元の変更の影響を受けていない
    ASSERT_EQ(1, va_arg(va2, int));
    ASSERT_EQ(2, va_arg(va2, int));
    ASSERT_EQ(3, va_arg(va2, int));

    va_end(va2);
    va_end(va1);
}

TEST(VaCopy, TestVaCopyVaListParameter)
{
    CallTestVaCopyVaListParameter(0, 1, 2, 3);
}

TEST(VaCopy, TestVaCopyVaListVariable)
{
    TestVaCopyVaListVariable(0, 1, 2, 3);
}
