﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <cstdlib>
#include <nn/nn_Log.h>
#include <nnt/nntest.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/teamcity/testTeamcity_Logger.h>
#include <nnt/nnt_Argument.h>

int  g_RepeatCount        = 10;    // 何回繰り返した平均をパフォーマンス値として出力するか
bool g_IsPerfCheckEnabled = false; // パフォーマンスが所定の値以下であったら失敗扱いする
int  g_PerformanceMargin  = 5;     // 何 % の揺れ幅をマージンとして許容するか

bool ParseArgument(int argc, char** argv)
{
    static const char TestArgRepeatCount[]      = "--cryptotest_repeat_count";
    static const char TestArgEnablePerfCheck[]  = "--cryptotest_check_perf";
    static const char TestArgPerfMargin[]       = "--cryptotest_perf_margin";

    while (argc--)
    {
        if (strncmp(argv[0], TestArgRepeatCount, sizeof(TestArgRepeatCount) - 1) == 0 &&
            argv[0][sizeof(TestArgRepeatCount) - 1] == '=')
        {
            g_RepeatCount = std::atoi(argv[0] + sizeof(TestArgRepeatCount));
        }
        else if (strncmp(argv[0], TestArgEnablePerfCheck, sizeof(TestArgEnablePerfCheck)) == 0)
        {
            g_IsPerfCheckEnabled = true;
        }
        else if (strncmp(argv[0], TestArgPerfMargin, sizeof(TestArgPerfMargin) - 1) == 0 &&
                 argv[0][sizeof(TestArgPerfMargin) - 1] == '=')
        {
            g_PerformanceMargin = std::atoi(argv[0] + sizeof(TestArgPerfMargin));
        }
        else if (strncmp(argv[0], "--cryptotest", 12) == 0)
        {
            NN_LOG("Error: Unknown option specified: %s\n", argv[0]);
            NN_LOG("Possible options are:\n");
            NN_LOG("    %s\n", TestArgRepeatCount);
            NN_LOG("    %s\n", TestArgEnablePerfCheck);
            NN_LOG("    %s\n", TestArgPerfMargin);
            NN_LOG("\n");
            return false;
        }
        argv++;
    }

    return true;
}

extern "C" void nnMain()
{
    int argc = ::nnt::GetHostArgc();
    char** argv = ::nnt::GetHostArgv();

    // local command arg parser
    if (!ParseArgument(argc, argv))
    {
        ::nnt::Exit(-1);
    }

    NN_LOG("Running nnMain() from testCrypto_Main.cpp\n");
    ::testing::InitGoogleTest(&argc, argv);

    ::testing::TestEventListeners& listeners =
        ::testing::UnitTest::GetInstance()->listeners();
    ::testing::TestEventListener* defaultResultPrinter =
        listeners.Release(listeners.default_result_printer());
#if defined(NN_BUILD_CONFIG_HARDWARE_BDSLIMX6) || defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1) || defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || defined(NN_BUILD_CONFIG_HARDWARE_NX)
    listeners.Append(new ::nnt::teamcity::ServiceMessageLogger());
#endif
    listeners.Append(defaultResultPrinter);

    int result = RUN_ALL_TESTS();
    ::nnt::Exit(result);
}
