﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/crypto/crypto_RsaPkcs1Verifier.h>
#include <nn/crypto/crypto_RsaPkcs1Signer.h>
#include <nn/crypto/crypto_Sha1Generator.h>
#include <nn/crypto/crypto_Sha256Generator.h>
#include "RsaParser.h"

class RsaPkcs1SigVerParser : public RsaSigVerParser
{
public:
    virtual void TestVerify( const std::string& sha,
                             const void* n, size_t nSize,
                             const void* e, size_t eSize,
                             const void* pMessage, size_t messageSize,
                             const void* pSignature, size_t signatureSize, bool expected) override
    {
        if (sha == "SHA1")
        {
            if ( nSize == 2048 / 8 )
            {
                typedef nn::crypto::RsaPkcs1Verifier<2048 / 8,
                                                      nn::crypto::Sha1Generator> Rsa2048Pkcs1Sha1;
                ASSERT_EQ( expected,
                           Rsa2048Pkcs1Sha1::Verify( pSignature, signatureSize, n, nSize, e,
                                                     eSize, pMessage,
                                                     messageSize ) );
                return;
            }
            if ( nSize == 4096 / 8 )
            {
                typedef nn::crypto::RsaPkcs1Verifier<4096 / 8,
                                                      nn::crypto::Sha1Generator> Rsa4096Pkcs1Sha1;
                ASSERT_EQ( expected,
                           Rsa4096Pkcs1Sha1::Verify( pSignature, signatureSize, n, nSize, e,
                                                     eSize, pMessage,
                                                     messageSize ) );
                return;
            }
        }
        if (sha == "SHA256")
        {
            if ( nSize == 2048 / 8 )
            {
                typedef nn::crypto::RsaPkcs1Verifier<2048 / 8,
                                                      nn::crypto::Sha256Generator>
                    Rsa2048Pkcs1Sha256;
                ASSERT_EQ( expected,
                           Rsa2048Pkcs1Sha256::Verify( pSignature, signatureSize, n, nSize, e,
                                                       eSize,
                                                       pMessage, messageSize ) );
                return;
            }
            if ( nSize == 4096 / 8 )
            {
                typedef nn::crypto::RsaPkcs1Verifier<4096 / 8,
                                                      nn::crypto::Sha256Generator>
                    Rsa4096Pkcs1Sha256;
                ASSERT_EQ( expected,
                           Rsa4096Pkcs1Sha256::Verify( pSignature, signatureSize, n, nSize, e,
                                                       eSize,
                                                       pMessage, messageSize ) );
                return;
            }
        }

        m_Skipped = true;
    }
};

class RsaPkcs1SigGenParser : public RsaSigGenParser
{
public:
    virtual void TestSign(const std::string& sha,
                          const void* n, size_t nSize,
                          const void* d, size_t dSize,
                          const void* pMessage, size_t messageSize,
                          void* outSignature, size_t signatureSize,
                          const std::string& expected) override
    {
        if (sha == "SHA1")
        {
            if ( nSize == 2048 / 8 )
            {
                typedef nn::crypto::RsaPkcs1Signer<2048 / 8,
                                                    nn::crypto::Sha1Generator> Rsa2048Pkcs1Sha1;
                Rsa2048Pkcs1Sha1::Sign( outSignature, signatureSize, n, nSize, d, dSize, pMessage,
                                        messageSize );
                ASSERT_EQ( expected,
                           std::string(static_cast<const char*>(outSignature), signatureSize) );
                return;
            }
            if ( nSize == 4096 / 8 )
            {
                typedef nn::crypto::RsaPkcs1Signer<4096 / 8,
                                                    nn::crypto::Sha1Generator> Rsa4096Pkcs1Sha1;
                Rsa4096Pkcs1Sha1::Sign( outSignature, signatureSize, n, nSize, d, dSize, pMessage,
                                        messageSize );
                ASSERT_EQ( expected,
                           std::string(static_cast<const char*>(outSignature), signatureSize) );
                return;
            }
        }
        if (sha == "SHA256")
        {
            if ( nSize == 2048 / 8 )
            {
                typedef nn::crypto::RsaPkcs1Signer<2048 / 8,
                                                    nn::crypto::Sha256Generator> Rsa2048Pkcs1Sha256;
                Rsa2048Pkcs1Sha256::Sign( outSignature, signatureSize, n, nSize, d, dSize,
                                          pMessage, messageSize );
                ASSERT_EQ( expected,
                           std::string(static_cast<const char*>(outSignature), signatureSize) );
                return;
            }
            if ( nSize == 4096 / 8 )
            {
                typedef nn::crypto::RsaPkcs1Signer<4096 / 8,
                                                    nn::crypto::Sha256Generator> Rsa4096Pkcs1Sha256;
                Rsa4096Pkcs1Sha256::Sign( outSignature, signatureSize, n, nSize, d, dSize,
                                          pMessage, messageSize );
                ASSERT_EQ( expected,
                           std::string(static_cast<const char*>(outSignature), signatureSize) );
                return;
            }
        }

        m_Skipped = true;
    }
};

TEST(RsaTest, Pkcs1_SigGen)
{
    RsaPkcs1SigGenParser tester;
    tester.TestFile("186-2rsatestvectors/SigGen15_186-2.txt",40);
}

TEST(RsaTest, Pkcs1_SigVer)
{
    RsaPkcs1SigVerParser tester;
    tester.TestFile("186-2rsatestvectors/SigVer15_186-3.rsp",72);
}
