﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/crypto/crypto_PasswordBasedKeyGenerator.h>

#include "testCrypto_Util.h"

/*
    byte[] passphrase = Encoding.ASCII.GetBytes("passphrase");
    byte[] salt = Encoding.ASCII.GetBytes("12345678");

    System.Security.Cryptography.Rfc2898DeriveBytes deriveBytes =
        new System.Security.Cryptography.Rfc2898DeriveBytes(passphrase, salt, 4096);

    byte[] bytes = deriveBytes.GetBytes(512);
*/
nn::Bit8 s_Sha1Data[] =
{
    0x60, 0xE0, 0x89, 0xE6, 0xC2, 0x1D, 0xC8, 0x0E, 0x16, 0xEB, 0x51, 0xBE, 0x35, 0x7E, 0x80, 0x6E,
    0xAC, 0x2E, 0xB2, 0xA8, 0x04, 0x05, 0xF6, 0x79, 0xBF, 0x97, 0xA8, 0xE8, 0x68, 0x4C, 0x47, 0x7B,
    0x43, 0x67, 0x32, 0xE8, 0xAD, 0x33, 0xAB, 0x9A, 0x43, 0xCD, 0x9F, 0xBC, 0x8A, 0x31, 0x26, 0x7C,
    0x13, 0x74, 0x32, 0xFD, 0xB6, 0x7E, 0x33, 0x00, 0x13, 0x8A, 0xED, 0xDF, 0x2F, 0x7A, 0x8E, 0x59,
    0x51, 0x0D, 0x45, 0x25, 0xA9, 0xAF, 0x8C, 0x75, 0xAE, 0x5E, 0xB7, 0xF0, 0xFF, 0xD7, 0xD6, 0x52,
    0x67, 0xEF, 0xB3, 0xA6, 0xC3, 0x33, 0xAD, 0x0E, 0x35, 0xB2, 0x05, 0x32, 0xFB, 0xA9, 0x59, 0x89,
    0xCC, 0x8B, 0x6C, 0x0E, 0xBF, 0xD4, 0x8C, 0x52, 0x94, 0x0F, 0x24, 0xB2, 0x94, 0x6C, 0x0D, 0x1B,
    0x2A, 0xE0, 0x65, 0xC7, 0x3C, 0x96, 0x8A, 0xD4, 0x00, 0x88, 0xA9, 0x79, 0xA8, 0xDE, 0x33, 0x9A,
    0xAE, 0xD1, 0x77, 0xD8, 0xE1, 0x07, 0x88, 0x95, 0x60, 0xBA, 0xEF, 0xBB, 0x9F, 0x8D, 0x91, 0x85,
    0x8A, 0x51, 0xFB, 0x8A, 0x02, 0x11, 0x17, 0x4A, 0x44, 0x01, 0x98, 0x4E, 0x94, 0x89, 0x2E, 0xAF,
    0x90, 0x17, 0xDE, 0xD9, 0x66, 0xF5, 0xEC, 0x81, 0xE0, 0xA1, 0xAD, 0x55, 0xA8, 0x71, 0xC7, 0x8D,
    0xB3, 0x2D, 0xFB, 0x05, 0x9C, 0xE4, 0x78, 0x8E, 0x7C, 0x7C, 0xB6, 0xDA, 0x16, 0x42, 0xBA, 0x26,
    0x21, 0x3D, 0x80, 0x09, 0x5A, 0xFD, 0x97, 0x6E, 0x3F, 0xB4, 0x77, 0x37, 0xB9, 0x5E, 0xC1, 0x27,
    0x9F, 0xA2, 0x58, 0x74, 0x7E, 0xB1, 0x6C, 0x62, 0x10, 0xBA, 0xEE, 0xC2, 0x39, 0x73, 0x5A, 0xEC,
    0xA8, 0x8E, 0x4A, 0xC9, 0x49, 0x0B, 0x98, 0xF3, 0xF3, 0x6B, 0x8C, 0xE5, 0xA4, 0x34, 0x55, 0x0F,
    0xF7, 0xD9, 0x96, 0x91, 0x99, 0x85, 0xCC, 0xF4, 0xA7, 0xE5, 0xD4, 0x98, 0x2D, 0x63, 0xE9, 0xCD,
    0x50, 0x08, 0xDD, 0xCB, 0x5F, 0xCF, 0x2E, 0xE1, 0xC5, 0x2E, 0x6A, 0x00, 0xB5, 0x79, 0x8A, 0x90,
    0x35, 0xA8, 0x9A, 0x9F, 0x04, 0xAB, 0x8D, 0x27, 0x0C, 0x7D, 0xED, 0x50, 0xED, 0x30, 0xBE, 0x39,
    0xCC, 0x4D, 0xB8, 0x36, 0x1E, 0xA7, 0x1F, 0xEE, 0x4C, 0x2E, 0x73, 0xC1, 0x9A, 0x95, 0x7C, 0xDA,
    0x4B, 0x68, 0x79, 0x5B, 0xF8, 0x08, 0x5C, 0x27, 0x90, 0x9F, 0x49, 0xB2, 0x57, 0x4B, 0x1D, 0x74,
    0xB8, 0x80, 0x43, 0xC1, 0x77, 0x30, 0xEF, 0x3B, 0x7B, 0xEC, 0x2F, 0xA2, 0xEE, 0x86, 0x68, 0x4F,
    0x97, 0xB1, 0x79, 0xAF, 0x4B, 0x80, 0x8B, 0xEA, 0x75, 0xDA, 0x94, 0xDA, 0x38, 0x2F, 0x1A, 0xD8,
    0x8D, 0x63, 0x28, 0x3F, 0xBF, 0x4F, 0x6E, 0xF4, 0x35, 0x37, 0xE0, 0xCB, 0xB5, 0x3F, 0x9F, 0x98,
    0x9F, 0xAC, 0x00, 0xF9, 0x07, 0x9E, 0x8B, 0x89, 0x0A, 0xB8, 0x58, 0x3F, 0x2A, 0x3D, 0xD1, 0x26,
    0xBA, 0xB5, 0x13, 0x7C, 0x36, 0xC7, 0x07, 0x65, 0xBE, 0xD1, 0x2F, 0x94, 0xD9, 0xCC, 0xD9, 0x6D,
    0x8E, 0x0D, 0xF4, 0xC5, 0x8F, 0xC0, 0xD6, 0x01, 0xD6, 0x32, 0xD3, 0xE8, 0x3D, 0x3D, 0xBF, 0xB5,
    0xB6, 0x33, 0xD4, 0xBE, 0x4A, 0x31, 0xDD, 0x61, 0xB9, 0x85, 0xE1, 0x17, 0xFB, 0xBF, 0xA2, 0xFB,
    0xCA, 0x32, 0x8B, 0xF7, 0x55, 0x96, 0xF4, 0xAD, 0x2D, 0x8D, 0x35, 0xF1, 0x65, 0xA9, 0x00, 0x4C,
    0x2B, 0x86, 0xA1, 0x99, 0x7D, 0xEB, 0xF9, 0xC7, 0x6D, 0xD4, 0xEC, 0x84, 0xC7, 0xE5, 0xAC, 0xBC,
    0x2E, 0x35, 0xBE, 0x63, 0x39, 0xE6, 0x75, 0xC2, 0x09, 0x33, 0xFE, 0xC1, 0x76, 0x60, 0xF8, 0x32,
    0x43, 0xA5, 0x70, 0xCC, 0x4B, 0xE6, 0x79, 0x1A, 0x85, 0xE8, 0x9E, 0xD6, 0xD0, 0x71, 0xDA, 0xB7,
    0xD7, 0x67, 0x81, 0xA6, 0x3F, 0xB5, 0x88, 0x31, 0xD2, 0x60, 0x70, 0x7B, 0xC7, 0xD1, 0xA1, 0x83
};

nn::Bit8 s_Sha256Data[] =
{
    0xF6, 0x12, 0xEC, 0x9A, 0xE7, 0x29, 0x5D, 0x68, 0xCD, 0x08, 0xCD, 0xED, 0x40, 0x0D, 0x6E, 0x23,
    0x38, 0x25, 0xC2, 0xBC, 0xF5, 0xAE, 0x36, 0x96, 0x19, 0xAF, 0x68, 0x55, 0x1A, 0x98, 0xC5, 0x69,
    0xCF, 0x0B, 0xA3, 0xBB, 0xD2, 0x4A, 0x17, 0xDD, 0x21, 0x66, 0x5D, 0xC6, 0x54, 0x85, 0xED, 0xE0,
    0x79, 0x54, 0xF7, 0x9B, 0x6F, 0xE4, 0xFD, 0x65, 0xE3, 0x5B, 0x7C, 0xF5, 0xBD, 0x09, 0x94, 0x83,
    0x3C, 0x04, 0xDE, 0x5C, 0xCB, 0x1F, 0x45, 0x03, 0x2E, 0x60, 0xE5, 0x78, 0xCC, 0xDB, 0x76, 0xDC,
    0x2F, 0xBA, 0xA1, 0x67, 0x65, 0xB5, 0xFF, 0xD8, 0xC0, 0x43, 0x3E, 0x2D, 0x5A, 0xDB, 0x6A, 0xA8,
    0xF7, 0xA7, 0x98, 0x33, 0xC0, 0xD1, 0x4B, 0x16, 0x6E, 0xA3, 0x4E, 0x26, 0xD3, 0x41, 0x45, 0xCC,
    0x9D, 0x2C, 0x83, 0x06, 0x80, 0xC2, 0xEE, 0xF4, 0x2A, 0x57, 0xF8, 0xD3, 0xD2, 0x30, 0x8D, 0x18,
    0x23, 0x1B, 0x1C, 0x59, 0xCC, 0x77, 0x85, 0x3F, 0xF6, 0xCD, 0xC2, 0xDF, 0x3A, 0xE8, 0x20, 0x16,
    0x79, 0x1A, 0xBF, 0xEB, 0x8A, 0xBB, 0x8F, 0xF1, 0xAE, 0x2A, 0xDF, 0xED, 0xCC, 0xE3, 0xB3, 0xA3,
    0xAC, 0x5E, 0xF3, 0xA9, 0xB7, 0xE7, 0x9D, 0x80, 0xB5, 0x73, 0x86, 0x67, 0x19, 0xD8, 0x07, 0xB2,
    0x04, 0x33, 0x75, 0x82, 0xB0, 0xA1, 0xF1, 0x87, 0xB4, 0x75, 0x31, 0x22, 0x2E, 0xB5, 0xF0, 0x81,
    0x02, 0x34, 0xFF, 0x0A, 0x4D, 0x01, 0xF4, 0x17, 0x84, 0x13, 0xED, 0x24, 0x4E, 0x6A, 0x71, 0x84,
    0x95, 0xCB, 0x75, 0xF0, 0xEA, 0x97, 0xBF, 0xFD, 0xE0, 0x61, 0x2A, 0x4F, 0x2F, 0x53, 0x3A, 0x55,
    0xAF, 0xD6, 0x3B, 0x3B, 0xDE, 0x0C, 0xD4, 0xB7, 0xC5, 0xE7, 0xD8, 0x2B, 0x5D, 0x7A, 0xD2, 0x54,
    0xCD, 0x44, 0xC5, 0x61, 0xE6, 0x25, 0x1B, 0xE4, 0x06, 0xDA, 0x5D, 0x57, 0x30, 0xEF, 0xC0, 0x00,
    0xD5, 0xC7, 0x04, 0x0B, 0xB2, 0xD6, 0xF9, 0x11, 0xBC, 0x5C, 0xE8, 0x64, 0x7F, 0xD7, 0xDB, 0x59,
    0x8B, 0xC9, 0x4E, 0x6D, 0x3B, 0x7B, 0x91, 0xE9, 0x5C, 0x2D, 0xD3, 0xF0, 0x64, 0x52, 0xBF, 0xF2,
    0xA8, 0xAE, 0x0C, 0x28, 0x46, 0xA0, 0x88, 0x86, 0x0F, 0x23, 0xD4, 0x65, 0xF1, 0x51, 0xE0, 0x12,
    0x2D, 0xB2, 0xE0, 0x3E, 0x1D, 0xCE, 0x3D, 0x5F, 0x33, 0xAD, 0x50, 0x25, 0x39, 0x08, 0x1A, 0xE5,
    0x87, 0x90, 0x92, 0xD2, 0x05, 0xC2, 0x98, 0x60, 0x7C, 0xEB, 0x3B, 0x7A, 0xB7, 0x82, 0xC2, 0x54,
    0xDE, 0x1E, 0xCB, 0x0B, 0x72, 0x79, 0xD5, 0x9A, 0x78, 0x48, 0x59, 0x2C, 0x9D, 0xA9, 0xEB, 0xDD,
    0x5D, 0xAE, 0x48, 0xFF, 0x14, 0x45, 0xD2, 0xC9, 0x6D, 0xE0, 0x09, 0xD0, 0x58, 0xF8, 0xA8, 0x5E,
    0xA6, 0x6F, 0xF3, 0xBB, 0xA2, 0xAB, 0x27, 0x95, 0x29, 0xA5, 0x9F, 0x42, 0xF8, 0x2C, 0x3A, 0x81,
    0x2B, 0xB3, 0x9F, 0xE9, 0x47, 0xF6, 0xFD, 0x14, 0x88, 0x4A, 0xB3, 0x1E, 0x4B, 0xB3, 0x2B, 0x75,
    0xAA, 0xC0, 0x59, 0xA6, 0x2A, 0x4C, 0xDD, 0x07, 0xBD, 0xC1, 0xA6, 0x0A, 0xEA, 0x84, 0x92, 0x53,
    0xA3, 0x66, 0x26, 0x8A, 0xCB, 0x6E, 0x35, 0x5A, 0xE6, 0x8F, 0x5A, 0xED, 0x56, 0x7A, 0x10, 0xF2,
    0xF7, 0xE1, 0x7A, 0x90, 0x38, 0xDA, 0x08, 0x16, 0x14, 0xE4, 0xBC, 0xA1, 0x06, 0xDA, 0x7D, 0x0B,
    0xB7, 0x73, 0xEF, 0xB4, 0x42, 0x35, 0x17, 0x63, 0x1A, 0xD9, 0xBE, 0xEA, 0x94, 0x75, 0xA4, 0x7C,
    0xC1, 0x53, 0xB4, 0x23, 0x4F, 0x3C, 0xE2, 0x2B, 0xE3, 0x4D, 0x4E, 0xB0, 0xFA, 0xE1, 0xCB, 0x16,
    0xE7, 0xC3, 0x8F, 0x8E, 0x7A, 0x6D, 0x23, 0xA5, 0x72, 0x40, 0x87, 0x5A, 0xEA, 0xE4, 0xBD, 0x4F,
    0xE6, 0xEB, 0xB2, 0xD8, 0x10, 0xFF, 0xF9, 0x0D, 0xCE, 0x82, 0x82, 0x24, 0x75, 0x2F, 0x9F, 0x10
};

TEST(PasswordBasedKeyGeneratorTest, Sha1)
{
    nn::crypto::PasswordBasedKeyGenerator<nn::crypto::Sha1Generator> generator;

    const char PASSPHRASE[] = "passphrase";
    const char SALT[] = "12345678";

    nn::Bit8 passphrase[64] = {};
    memcpy(passphrase, PASSPHRASE, sizeof (PASSPHRASE) - 1);

    nn::Bit8 salt[64] = {};
    memcpy(salt, SALT, sizeof (SALT) - 1);

    static nn::Bit8 buffer[sizeof (s_Sha1Data)];

    // 一気に全部
    {
        generator.Initialize(passphrase, sizeof (PASSPHRASE) - 1, salt, sizeof (SALT) - 1, 4096);
        generator.GetBytes(buffer, sizeof (s_Sha1Data));

        EXPECT_ARRAY_EQ(buffer, s_Sha1Data, sizeof (s_Sha1Data));
    }

    const size_t STEPS[] = {1, 4, 7, 19, 20, 31, 32, 99, 0};

    // 任意のバイト数ずつ
    for (size_t step = 0; STEPS[step] != 0; step++)
    {
        generator.Initialize(passphrase, sizeof (PASSPHRASE) - 1, salt, sizeof (SALT) - 1, 4096);

        size_t loop = sizeof (s_Sha1Data) / STEPS[step];

        for (size_t i = 0; i < loop; i++)
        {
            generator.GetBytes(&buffer[i * STEPS[step]], STEPS[step]);
        }

        size_t processed = loop * STEPS[step];

        if (processed != sizeof (s_Sha1Data))
        {
            generator.GetBytes(&buffer[processed], sizeof (s_Sha1Data) - processed);
        }

        EXPECT_ARRAY_EQ(buffer, s_Sha1Data, sizeof (s_Sha1Data));
    }
}

TEST(PasswordBasedKeyGeneratorTest, Sha256)
{
    nn::crypto::PasswordBasedKeyGenerator<nn::crypto::Sha256Generator> generator;

    const char PASSPHRASE[] = "passphrase";
    const char SALT[] = "12345678";

    nn::Bit8 passphrase[64] = {};
    memcpy(passphrase, PASSPHRASE, sizeof (PASSPHRASE) - 1);

    nn::Bit8 salt[64] = {};
    memcpy(salt, SALT, sizeof (SALT) - 1);

    static nn::Bit8 buffer[sizeof (s_Sha256Data)];

    // 一気に全部
    {
        generator.Initialize(passphrase, sizeof (PASSPHRASE) - 1, salt, sizeof (SALT) - 1, 4096);
        generator.GetBytes(buffer, sizeof (s_Sha256Data));

        EXPECT_ARRAY_EQ(buffer, s_Sha256Data, sizeof (s_Sha256Data));
    }

    const size_t STEPS[] = {1, 4, 7, 19, 20, 31, 32, 99, 0};

    // 任意のバイト数ずつ
    for (size_t step = 0; STEPS[step] != 0; step++)
    {
        generator.Initialize(passphrase, sizeof (PASSPHRASE) - 1, salt, sizeof (SALT) - 1, 4096);

        size_t loop = sizeof (s_Sha256Data) / STEPS[step];

        for (size_t i = 0; i < loop; i++)
        {
            generator.GetBytes(&buffer[i * STEPS[step]], STEPS[step]);
        }

        size_t processed = loop * STEPS[step];

        if (processed != sizeof (s_Sha256Data))
        {
            generator.GetBytes(&buffer[processed], sizeof (s_Sha256Data) - processed);
        }

        EXPECT_ARRAY_EQ(buffer, s_Sha256Data, sizeof (s_Sha256Data));
    }
}

TEST(PasswordBasedKeyGeneratorTest, Destructor)
{
    const char PASSPHRASE[] = "passphrase";
    const char SALT[] = "12345678";

    nn::Bit8 passphrase[64] = {};
    memcpy(passphrase, PASSPHRASE, sizeof (PASSPHRASE) - 1);

    nn::Bit8 salt[64] = {};
    memcpy(salt, SALT, sizeof (SALT) - 1);

    // SHA1
    {
        nn::crypto::PasswordBasedKeyGenerator<nn::crypto::Sha1Generator> generator;
        generator.Initialize(passphrase, sizeof (PASSPHRASE) - 1, salt, sizeof (SALT) - 1, 4096);

        // 明示的にデストラクタを呼んで呼び出し前後でのメモリクリアを確認する
        EXPECT_ARRAY_NONZERO(&generator, sizeof(generator));
        generator.~PasswordBasedKeyGenerator();
        EXPECT_ARRAY_ZERO(&generator, sizeof(generator));
    }

    // SHA256
    {
        nn::crypto::PasswordBasedKeyGenerator<nn::crypto::Sha256Generator> generator;
        generator.Initialize(passphrase, sizeof (PASSPHRASE) - 1, salt, sizeof (SALT) - 1, 4096);

        // 明示的にデストラクタを呼んで呼び出し前後でのメモリクリアを確認する
        EXPECT_ARRAY_NONZERO(&generator, sizeof(generator));
        generator.~PasswordBasedKeyGenerator();
        EXPECT_ARRAY_ZERO(&generator, sizeof(generator));
    }
}
