﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nn/nn_Log.h>
#include <nnt/teamcity/testTeamcity_Logger.h>

namespace nnt { namespace teamcity {
    /**
        @brief
            TeamCity の Service Message フォーマットでログ出力するための
            イベントリスナの定義
    */
    // テストケース開始前に呼ばれます
    void ServiceMessageLogger::OnTestCaseStart(const ::testing::TestCase& test_case)
    {
        NN_LOG("##teamcity[testSuiteStarted name='%s']\n", test_case.name());
    }

    // テスト開始前に呼ばれます
    void ServiceMessageLogger::OnTestStart(const ::testing::TestInfo& test_info)
    {
        NN_LOG("##teamcity[testStarted name ='%s' captureStandardOutput='true']\n", test_info.name());
    }

    // テスト終了後に呼ばれます
    void ServiceMessageLogger::OnTestEnd(const ::testing::TestInfo& test_info)
    {
        if (test_info.result()->Failed())
        {
            NN_LOG("##teamcity[testFailed name='%s' message='FAILED' duration='%lld']\n", test_info.name(), test_info.result()->elapsed_time());
        }

        NN_LOG("##teamcity[testFinished name ='%s' duration='%lld']\n", test_info.name(), test_info.result()->elapsed_time());
    }

    // テストケース終了後に呼ばれます
    void ServiceMessageLogger::OnTestCaseEnd(const ::testing::TestCase& test_case)
    {
        NN_LOG("##teamcity[testSuiteFinished name='%s' duration='%lld']\n", test_case.name(), test_case.elapsed_time());
    }
}}
