﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/graphics/testGraphics_GetHostExecutableFilepath.h>

#include <nn/nn_Assert.h>
#include <nnt/nnt_Argument.h>
#include <nn/nn_Log.h>
#include <nn/util/util_StringUtil.h>

#if defined(NN_BUILD_CONFIG_OS_WIN32)
    #error Win32 向けのビルドでは Win32 用実装分岐を使用してください。
#endif

namespace nnt{ namespace graphics{


    const char* GetHostExecutableFilepath() NN_NOEXCEPT
    {
        static const int Capacity = 512;
        static const char HostPrefix[] = "host:";

        static char s_ExecutableDirectoryPath[Capacity] = "";

        if(s_ExecutableDirectoryPath[0] != '\0')
        {
            return s_ExecutableDirectoryPath;
        }

        int argc = nnt::GetHostArgc();
        char** argv = nnt::GetHostArgv();
        NN_ASSERT(argc > 0, "Failed to get executable path from argv.");

        const char* src = argv[0];
        int srcLength = nn::util::Strnlen(src, Capacity);
        int prefixLength = nn::util::Strnlen(HostPrefix, Capacity);
        int startPosition = 0;

        // "host:" で始まっているならその部分をスキップ
        if(srcLength >= prefixLength)
        {
            for(startPosition = 0; startPosition < prefixLength; startPosition++)
            {
                if(src[startPosition] != HostPrefix[startPosition])
                {
                    startPosition = 0;
                    break;
                }
            }
        }

        nn::util::Strlcpy(s_ExecutableDirectoryPath, src + startPosition, Capacity);

        return s_ExecutableDirectoryPath;
    }

}}
