﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs.h>
#include <nnt/gfx/testGfx_FileSystem.h>

namespace nnt {
namespace gfx {

//------------------------------------------------------------------------------
//  唯一のインスタンスを取得
//------------------------------------------------------------------------------
NntGfxFileSystem& NntGfxFileSystem::GetInstance()
{
    static NntGfxFileSystem s_instance;
    return s_instance;
}

//---------------------------------------------------------------------------
//  ヒープを設定
//---------------------------------------------------------------------------
void NntGfxFileSystem::SetHeap( nn::lmem::HeapHandle pHeapHandle )
{
    m_HeapHandle = pHeapHandle;
}

//------------------------------------------------------------------------------
//  ファイルから読み込んだデータを破棄
//------------------------------------------------------------------------------
void NntGfxFileSystem::ReleaseData( uint8_t* pData )
{
    nn::lmem::FreeToExpHeap(m_HeapHandle, pData);
}

}
}
