﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../Fx3Control/Fx3Control.h"

namespace nnt {
namespace usb {
namespace cdmsc {

extern bool g_DownloadFirmware;

TEST(Fx3MscTestSuite, Read11_2)
{
    nn::cdmsc::UnitProfile profile;
    uint16_t commandInfo = 0;
    uint16_t logType = 0;
    int countReadCommands = 0;
    int logIndex = 0;
    bool hasStartStopUnit = false;
     NN_USB_DMA_ALIGN Fx3TestResponse testResponse = { 0 };
     NN_USB_DMA_ALIGN uint8_t readLogData[Fx3CommandLogLength] = { 0 };

    Fx3Reset(WAIT_SECONDS_FOR_ATTACH, g_DownloadFirmware);

    // Configure Fx3 to complete Read with sense code 2-4-2
    // Expect a StartStopUnit
    commandInfo = Fx3MscCommand_Read10 << 8;
     testResponse.Type = Fx3MscTestResponseType_StallAndSetSenseCodeTableIndex;
     testResponse.u.SenseCodeTableIndex.Index = Fx3MscSenseCodesIndex_LOGICAL_DRIVE_NOT_READY_INITIALIZATION_REQUIRED;

    Fx3SendVendorSpecificRequest(
        (uint8_t*)&testResponse,
        0x40,
         Fx3Request_SetTestResponse,
        commandInfo,
        0,
        sizeof(testResponse)
    );

    // clear command log
    logType = Fx3ClearCommandLog << 8;

    Fx3SendVendorSpecificRequest(
        nullptr,
        0x40,
        Fx3Request_ClearLog,
        logType,
        0x00,
        0x00
    );

    Fx3ActivateMassStorageMode(WAIT_SECONDS_FOR_ATTACH);
    NNT_EXPECT_RESULT_SUCCESS(Fx3Probe(&profile));

    FX3_LOG("Vid: %d, PID:%d\n", profile.vid, profile.pid);

    // Read10 is called on enumeration

    // Get Command log and check for StartStopUnit cmd and two Read10 commands
    Fx3SendVendorSpecificRequest(
        readLogData,
        0xC0,
        Fx3Request_GetCommandLog,
        0x00,
        0x00,
        Fx3CommandLogLength
    );

    for (logIndex = 0; logIndex < Fx3CommandLogLength; logIndex++)
    {
        if (readLogData[logIndex] == Fx3MscCommand_Read10)
        {
            countReadCommands++;
        }
        else if (readLogData[logIndex] == Fx3MscCommand_StartStopUnit)
        {
            hasStartStopUnit = true;
        }
    }

    EXPECT_EQ(2, countReadCommands);
    EXPECT_TRUE(hasStartStopUnit);
}

} // cdmsc
} // usb
} // nnt
