﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <algorithm>
#include <list>
#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/nn_Result.h>
#include <nn/capsrv/movie/capsrv_CachedMovieStream.h>

#define NNT_CAPSRV_LOG_MOVIESTREAMCACHESTRATEGY(...) NN_LOG(__VA_ARGS__)

#ifndef NNT_CAPSRV_LOG_MOVIESTREAMCACHESTRATEGY
#define NNT_CAPSRV_LOG_MOVIESTREAMCACHESTRATEGY(...)
#endif


namespace nnt{ namespace capsrv{ namespace detail{

    struct TestMovieStreamCacheStrategy
    {
    public:
        static void NotifyFetched(int64_t chunkIndex, void* userData) NN_NOEXCEPT
        {
            auto pSelf = reinterpret_cast<TestMovieStreamCacheStrategy*>(userData);
            auto it = std::find_if(pSelf->chunkList.begin(), pSelf->chunkList.end(), [&](int64_t v){ return v == chunkIndex; });
            NN_ASSERT_EQUAL(it, pSelf->chunkList.end());
            pSelf->chunkList.push_back(chunkIndex);

            NNT_CAPSRV_LOG_MOVIESTREAMCACHESTRATEGY("F->");
            for(auto v : pSelf->chunkList)
            {
                NN_UNUSED(v);
                NNT_CAPSRV_LOG_MOVIESTREAMCACHESTRATEGY("%lld,", v);
            }
            NNT_CAPSRV_LOG_MOVIESTREAMCACHESTRATEGY("\n");
        }

        static void NotifyInvalidated(int64_t chunkIndex, void* userData) NN_NOEXCEPT
        {
            auto pSelf = reinterpret_cast<TestMovieStreamCacheStrategy*>(userData);
            auto it = std::find_if(pSelf->chunkList.begin(), pSelf->chunkList.end(), [&](int64_t v){ return v == chunkIndex; });
            NN_ASSERT_NOT_EQUAL(it, pSelf->chunkList.end());
            pSelf->chunkList.erase(it);
            NNT_CAPSRV_LOG_MOVIESTREAMCACHESTRATEGY("I->");
            for(auto v : pSelf->chunkList)
            {
                NN_UNUSED(v);
                NNT_CAPSRV_LOG_MOVIESTREAMCACHESTRATEGY("%lld,", v);
            }
            NNT_CAPSRV_LOG_MOVIESTREAMCACHESTRATEGY("\n");
        }

        static void NotifyRead(int64_t chunkIndex, int64_t offset, int64_t size, void* userData) NN_NOEXCEPT
        {
            NN_UNUSED(chunkIndex);
            NN_UNUSED(offset);
            NN_UNUSED(size);
            NN_UNUSED(userData);
            //NNT_CAPSRV_LOG_MOVIESTREAMCACHESTRATEGY("R->%lld:%llu-%llu\n", chunkIndex, offset, offset + size);
            //auto pSelf = reinterpret_cast<TestMovieStreamCacheStrategy*>(userData);
            //auto it = std::find_if(pSelf->chunkList.begin(), pSelf->chunkList.end(), [&](int64_t v){ return v == chunkIndex; });
            //NN_ASSERT_NOT_EQUAL(it, pSelf->chunkList.end());
            //pSelf->chunkList.erase(it);
            //pSelf->chunkList.push_back(chunkIndex);
        }

        static void NotifyWritten(int64_t chunkIndex, int64_t offset, int64_t size, void* userData) NN_NOEXCEPT
        {
            NN_UNUSED(chunkIndex);
            NN_UNUSED(offset);
            NN_UNUSED(size);
            NN_UNUSED(userData);
            //NNT_CAPSRV_LOG_MOVIESTREAMCACHESTRATEGY("W->%lld:%llu-%llu\n", chunkIndex, offset, offset + size);
            //auto pSelf = reinterpret_cast<TestMovieStreamCacheStrategy*>(userData);
            //auto it = std::find_if(pSelf->chunkList.begin(), pSelf->chunkList.end(), [&](int64_t v){ return v == chunkIndex; });
            //NN_ASSERT_NOT_EQUAL(it, pSelf->chunkList.end());
            //pSelf->chunkList.erase(it);
            //pSelf->chunkList.push_back(chunkIndex);
        }

        static int64_t QueryChunkIndexToInvalidate(void* userData) NN_NOEXCEPT
        {
            auto pSelf = reinterpret_cast<TestMovieStreamCacheStrategy*>(userData);
            NN_ASSERT_GREATER(pSelf->chunkList.size(), 0u);
            return pSelf->chunkList.front();
        }

        nn::capsrv::movie::MovieStreamCacheStrategy GetStrategy() NN_NOEXCEPT
        {
            nn::capsrv::movie::MovieStreamCacheStrategy strategy = {};
            strategy.userData = this;
            strategy.notifyFetched = NotifyFetched;
            strategy.notifyInvalidated = NotifyInvalidated;
            strategy.notifyRead = NotifyRead;
            strategy.notifyWritten = NotifyWritten;
            strategy.queryChunkIndexToInvalidate = QueryChunkIndexToInvalidate;
            return strategy;
        }

    public:
        std::list<int64_t> chunkList;
    };

}}}
