﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <utility>
#include <nn/nn_Common.h>

namespace nnt{ namespace capsrv{ namespace threading{

    template<int DivideCountMax>
    struct StaticRange
    {
    public:
        StaticRange(int n, int divideCount) NN_NOEXCEPT
        {
            NN_ASSERT_MINMAX(divideCount, 0, DivideCountMax);
            int current = 0;
            for(int tid = 0; tid < divideCount; tid++)
            {
                m_List[tid].first = current;
                current = n * (tid + 1) / divideCount;
                m_List[tid].second = current;
            }
            m_List[divideCount - 1].second = n;
        }

        const std::pair<int, int>& operator() (int i) const NN_NOEXCEPT
        {
            return m_List[i];
        }

    public:
        std::pair<int, int> m_List[DivideCountMax];
    };

}}}
