﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#define NNT_CAPSRV_CAT_I(a,b) a ## b

// トークンを連結します
#define NNT_CAPSRV_CAT(a,b) NNT_CAPSRV_CAT_I(a,b)

// テンポラリ変数用の名前を生成します。
// nntCapsrv + baseName + 行番号。
#define NNT_CAPSRV_TMP_NAME(baseName) NNT_CAPSRV_CAT(nntCapsrv, NNT_CAPSRV_CAT( baseName, __LINE__) )

// ループ内に閉じたスコープの変数定義を行います。
// NNT_CAPSRV_FOREACH_VAR(int a = 0)。
#define NNT_CAPSRV_FOREACH_VAR(statement) \
    if(bool NNT_CAPSRV_TMP_NAME(ForeachVarOnceFlag) = true) \
    for( \
        statement; \
        NNT_CAPSRV_TMP_NAME(ForeachVarOnceFlag); \
        NNT_CAPSRV_TMP_NAME(ForeachVarOnceFlag) = false \
    )

// condition が false となるものを foreach で走る対象から除外します。
#define NNT_CAPSRV_FOREACH_FILTER(condition) \
    if(condition)

// 全てのストレージを走ります。
// counter … ストレージの通し番号(int)の変数名。マウントされていないものもカウントされます。
// var … ストレージの識別子(nn::capsrv::AlbumStorageType)の変数名。
#define NNT_CAPSRV_FOREACH_STORAGE_I(counter, var) \
    for(int counter  = 0; counter < nn::capsrv::AlbumStorageCount; counter++) \
        NNT_CAPSRV_FOREACH_VAR(const auto var = static_cast<nn::capsrv::AlbumStorageType>(counter))

// 全てのストレージを走ります。
// var … ストレージの識別子(nn::capsrv::AlbumStorageType)の変数名。
#define NNT_CAPSRV_FOREACH_STORAGE(var)   \
    NNT_CAPSRV_FOREACH_STORAGE_I(NNT_CAPSRV_TMP_NAME(Counter), var)

// 全てのマウント済のストレージを走ります。
// counter … ストレージの通し番号(int)の変数名。マウントされていないものもカウントされます。
// var … ストレージの識別子(nn::capsrv::AlbumStorageType)の変数名。
#define NNT_CAPSRV_FOREACH_MOUNTED_STORAGE_I(counter, var) \
    for(int counter  = 0; counter < nn::capsrv::AlbumStorageCount; counter++) \
        NNT_CAPSRV_FOREACH_VAR(const auto var = static_cast<nn::capsrv::AlbumStorageType>(counter)) \
        NNT_CAPSRV_FOREACH_FILTER(nn::capsrv::IsAlbumMounted(var))

// 全てのマウント済のストレージを走ります。
// var … ストレージの識別子(nn::capsrv::AlbumStorageType)の変数名。
#define NNT_CAPSRV_FOREACH_MOUNTED_STORAGE(var)   \
    NNT_CAPSRV_FOREACH_MOUNTED_STORAGE_I(NNT_CAPSRV_TMP_NAME(Counter), var)

// 全ての DirectAlbumAccessor によってマウント済のストレージを走ります。
// counter … ストレージの通し番号(int)の変数名。マウントされていないものもカウントされます。
// var … ストレージの識別子(nn::capsrv::AlbumStorageType)の変数名。
#define NNT_CAPSRV_FOREACH_DIRECT_MOUNTED_STORAGE_I(counter, var) \
    for(int counter  = 0; counter < nn::capsrv::AlbumStorageCount; counter++) \
        NNT_CAPSRV_FOREACH_VAR(const auto var = static_cast<nn::capsrv::AlbumStorageType>(counter)) \
        NNT_CAPSRV_FOREACH_FILTER(nnt::capsrv::DirectAlbumAccessor::IsMounted(var))

// 全ての DirectAlbumAccessor によってマウント済のストレージを走ります。
// var … ストレージの識別子(nn::capsrv::AlbumStorageType)の変数名。
#define NNT_CAPSRV_FOREACH_DIRECT_MOUNTED_STORAGE(var)   \
    NNT_CAPSRV_FOREACH_DIRECT_MOUNTED_STORAGE_I(NNT_CAPSRV_TMP_NAME(Counter), var)

// 全てのコンテンツの種類を走ります。
// counter … FileContents の通し番号(int)の変数名。
// var … FileContents の識別子(nn::capsrv::AlbumFileContentsType)の変数名。
#define NNT_CAPSRV_FOREACH_CONTENTS_I(counter, var) \
    for(int counter = 0; counter < nn::capsrv::AlbumFileContentsCount; counter++) \
        NNT_CAPSRV_FOREACH_VAR(const auto var = static_cast<nn::capsrv::AlbumFileContentsType>(counter))

// 全てのコンテンツの種類を走ります。
// var … FileContents の識別子(nn::capsrv::AlbumFileContentsType)の変数名。
#define NNT_CAPSRV_FOREACH_CONTENTS(var) \
    NNT_CAPSRV_FOREACH_CONTENTS_I(NNT_CAPSRV_TMP_NAME(Counter), var)

// 与えられたリスト中の全ての FileInfo を走ります。
// counter … リスト中のインデックス(int)の変数名。
// var … FileInfoの変数名
// fileInfoList … FileInfo のリスト。 fileInfoList[counter] で要素アクセスできる必要があります。
// fileInfoCount … fileInfoList の長さ(int)。
#define NNT_CAPSRV_FOREACH_FILEINFO_I(counter, var, fileInfoList, fileInfoCount) \
    for(int counter = 0; counter < (fileInfoCount); counter++) \
        NNT_CAPSRV_FOREACH_VAR(const auto& var = (fileInfoList)[counter])

// 与えられたリスト中の全ての FileInfo を走ります。
// var … FileInfoの変数名
// fileInfoList … FileInfo のリスト。 fileInfoList[i] で要素アクセスできる必要があります。
// fileInfoCount … fileInfoList の長さ(整数値)。
#define NNT_CAPSRV_FOREACH_FILEINFO(var, fileInfoList, fileInfoCount) \
    NNT_CAPSRV_FOREACH_FILEINFO_I(NNT_CAPSRV_TMP_NAME(Counter), var, fileInfoList, static_cast<int>(fileInfoCount))

//---------------------------

#define NNT_CAPSRV_EXPECT_RESULT_SUCCESS(result)    \
    EXPECT_TRUE(result.IsSuccess());    \
    if(result.IsFailure())  \
    {   \
        NN_LOG("  Module      : %d\n", result.GetModule());  \
        NN_LOG("  Description : %d\n", result.GetDescription());    \
    }

