﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include "BtmTools_Pad.h"

namespace nnt { namespace btm {

Pad::Pad() NN_NOEXCEPT
{
    std::memset(&m_NpadFullKeyState, 0, sizeof(nn::hid::NpadFullKeyState));
}

void Pad::Initialize() NN_NOEXCEPT
{
    nn::hid::InitializeNpad();

    //使用する操作形態を設定
    nn::hid::SetSupportedNpadStyleSet(nn::hid::NpadStyleFullKey::Mask | nn::hid::NpadStyleJoyDual::Mask | nn::hid::NpadStyleHandheld::Mask);

    // 使用する Npad を設定
    const nn::hid::NpadIdType npadIds[2] = {nn::hid::NpadId::No1, nn::hid::NpadId::Handheld};
    nn::hid::SetSupportedNpadIdType(npadIds, sizeof(npadIds) / sizeof(nn::hid::NpadIdType));
}

nn::hid::NpadButtonSet Pad::Update() NN_NOEXCEPT
{
    nn::hid::NpadButtonSet buttonSet = {};

    // フルキー操作が有効な場合
    if (nn::hid::GetNpadStyleSet(nn::hid::NpadId::No1).Test<nn::hid::NpadStyleFullKey>())
    {
        nn::hid::NpadFullKeyState state;
        nn::hid::GetNpadState(&state, nn::hid::NpadId::No1);
        buttonSet |= state.buttons & ~m_NpadFullKeyState.buttons;
        m_NpadFullKeyState = state;
    }

    // 携帯機コントローラー操作が有効な場合
    if (nn::hid::GetNpadStyleSet(nn::hid::NpadId::Handheld).Test<nn::hid::NpadStyleHandheld>())
    {
        nn::hid::NpadHandheldState state;
        nn::hid::GetNpadState(&state, nn::hid::NpadId::Handheld);
        buttonSet |= state.buttons & ~m_NpadHandheldState.buttons;
        m_NpadHandheldState = state;
    }

    // Joy-Con 操作が有効な場合
    if (nn::hid::GetNpadStyleSet(nn::hid::NpadId::No1).Test<nn::hid::NpadStyleJoyDual>())
    {
        nn::hid::NpadJoyDualState state;
        nn::hid::GetNpadState(&state, nn::hid::NpadId::No1);
        buttonSet |= state.buttons & ~m_NpadJoyDualState.buttons;
        m_NpadJoyDualState = state;
    }

    return buttonSet;
}

}}
