﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/nn_Macro.h>
#include <nns/gfx/gfx_GraphicsFramework.h>
#include <nns/gfx/gfx_PrimitiveRenderer.h>
#include <nn/gfx/util/gfx_DebugFontTextWriter.h>

namespace nnt { namespace btm {

class GraphicsSystem
{
    NN_DISALLOW_COPY(GraphicsSystem);
    NN_DISALLOW_MOVE(GraphicsSystem);

private:
    static const int DisplayWidth = 1280;
    static const int DisplayHeight = 720;

    static const int BufferCount = 2;

    static const int CharCountMax = 1024;

    nns::gfx::GraphicsFramework m_GraphicsFramework;

    size_t m_GraphicsSystemMemorySize;

    nn::gfx::MemoryPool* m_pMemoryPool;
    ptrdiff_t m_pMemoryPoolOffset;

    int m_TextureDescriptorIndex;
    int m_SamplerDescriptorIndex;

    nns::gfx::GraphicsFramework::DebugFontTextWriter m_DebugFontTextWriter;

    nns::gfx::PrimitiveRenderer::Renderer* m_pPrimitiveRenderer;

    uint64_t m_FrameCount;

private:
    static void MakeCommandFunc(nns::gfx::GraphicsFramework* pGraphicsFramework, int bufferIndex, void* pUserData) NN_NOEXCEPT;

public:
    GraphicsSystem() NN_NOEXCEPT;

    void Initialize(size_t graphicsSystemMemorySize) NN_NOEXCEPT;

    void Initialize(size_t graphicsSystemMemorySize, void (*makeCommandFunc)(nns::gfx::GraphicsFramework* pGraphicsFramework, int bufferIndex, void* pUserData)) NN_NOEXCEPT;

    void InitializeDebugFont() NN_NOEXCEPT;

    void InitializePrimitiveRenderer() NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;

    void FinalizeDebugFont() NN_NOEXCEPT;

    void FinalizePrimitiveRenderer() NN_NOEXCEPT;

    void Update() NN_NOEXCEPT;

    nn::gfx::util::DebugFontTextWriter* GetDebugFontTextWriter() NN_NOEXCEPT;

    nns::gfx::PrimitiveRenderer::Renderer* GetPrimitiveRenderer() NN_NOEXCEPT;
};

}}
