﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/bpc/bpc_PowerButton.h>
#include <nn/i2c/i2c.h>
#include <nn/result/result_HandlingUtility.h>

extern "C" void nninitStartup()
{
    ;
}

extern "C" void nnMain()
{
    NN_LOG("SleepButtonEventHandler started.\n");
    const uint8_t address = 0x41;
    const uint8_t mask = 0x38;
    uint8_t data = 0;
    nn::i2c::I2cSession session;

    nn::i2c::Initialize();
    nn::i2c::OpenSession(&session, nn::i2c::I2cDevice_Max77620Pmic);
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::i2c::ReadSingleRegister(&data, session, &address));
    data |= mask;
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::i2c::WriteSingleRegister(session, &address, &data));
    nn::i2c::CloseSession(session);
    nn::i2c::Finalize();

    nn::bpc::InitializePowerButton();

    {
        nn::os::SystemEventType event;
        NN_LOG("Waiting for sleep button shutdown (7 sec) event.\n");
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::bpc::GetPowerEvent(&event, nn::bpc::EventTarget_SleepButtonShutdown));
        nn::os::WaitSystemEvent(&event);
        nn::os::ClearSystemEvent(&event);
        NN_LOG("Received shutdown event.\n");
    }

    // SIGLO-43468: manual reset warning は max7762x ドライバの仕様変更により、割り込みが入らない仕様になっている為コメントアウトします。
    /*
    {
        nn::os::SystemEventType event;
        NN_LOG("Waiting for sleep button manual reset warning (10 sec) event.\n");
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::bpc::GetPowerEvent(&event, nn::bpc::EventTarget_SleepButtonManualResetWarning));
        nn::os::WaitSystemEvent(&event);
        nn::os::ClearSystemEvent(&event);
        NN_LOG("Received manual reset warning event.\n");
    }
    */

    nn::bpc::FinalizePowerButton();

    NN_LOG("SleepButtonEventHandler finished.\n");
}
