﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>

#include <nn/nn_Common.h>

#include "testBpc_ExpectedEntry.h"

namespace nnt { namespace bpc {

const std::vector<ExpectedEntry> Max77812_3_1ExpectedEntries =
{
    { 0x00, 0x00, 0x01 }, // RESET VALUE
    { 0x01, 0x00, 0x03 }, // RESET VALUE
    { 0x02, 0x02, 0x03 }, // RESET VALUE
    { 0x03, 0x00, 0x1f }, // RESET VALUE
    { 0x04, 0x13, 0x1f }, // RESET VALUE
    { 0x05, 0x00, 0x0f }, // 温度、電圧のいずれの異常も発生していない想定です。
    { 0x06, 0x41, 0xfc }, // GPU OFF でテストを実行することもあるので GPU 用の M1 はチェックしません。
    { 0x07, 0x00, 0x9f }, // RESET VALUE
    { 0x08, 0x00, 0x1f }, // RESET VALUE
    { 0x09, 0x00, 0x1f }, // RESET VALUE
    { 0x0a, 0x00, 0x1f }, // RESET VALUE
    { 0x0b, 0x00, 0x1f }, // RESET VALUE
    { 0x0c, 0x00, 0x1f }, // RESET VALUE
    { 0x0d, 0x00, 0x1f }, // RESET VALUE
    { 0x0e, 0x02, 0x07 }, // RESET VALUE
    { 0x0f, 0x43, 0xff }, // GPI1: M4_EN, GPI0: M3_EN に割り当てています。しかしGPI0,GPI1共に結線なしです。
    { 0x10, 0x11, 0xff }, // RESET VALUE
    { 0x11, 0x11, 0xff }, // RESET VALUE
    { 0x12, 0x0f, 0x0f }, // RESET VALUE
    { 0x13, 0x82, 0xf7 }, // RESET VALUE
    { 0x14, 0x05, 0x00 }, // RESET VALUE
    { 0x15, 0x10, 0x03 }, // RESET VALUE

    { 0x20, 0x00, 0x0f }, // RESET VALUE
    { 0x21, 0x0f, 0x0f }, // RESET VALUE
    { 0x22, 0x00, 0x00 }, // GPU, CPU 電源出力時に 0x00 となることから現在の状態をそのまま示してはいない様子です。
    { 0x23, 0x46, 0x6e, 0xff }, // GPU 電圧設定につき範囲指定が必要です。20170530_Mariko_SDEV_power_tree_diagram.pdf より 0.6000V ~ 0.8000V。
    { 0x24, 0x50, 0x00 }, // M2 はマスターにならないのでチェック不要です。
    { 0x25, 0x46, 0x00 }, // M3 はマスターにならないのでチェック不要です。
    { 0x26, 0x46, 0x6e, 0xff }, // CPU 電圧設定につき範囲指定が必要です。20170530_Mariko_SDEV_power_tree_diagram.pdf より 0.6000V ~ 0.8000V。
    { 0x27, 0x78, 0xff }, // RESET VALUE
    { 0x28, 0x78, 0xff }, // RESET VALUE
    { 0x29, 0x78, 0xff }, // RESET VALUE
    { 0x2a, 0x78, 0xff }, // RESET VALUE
    { 0x2b, 0x1e, 0xff }, // RESET VALUE
    { 0x2c, 0x1e, 0xff }, // RESET VALUE
    { 0x2d, 0x1e, 0xff }, // RESET VALUE
    { 0x2e, 0x1e, 0xff }, // RESET VALUE
    { 0x2f, 0xf1, 0xff }, // ILIM[6:4] のみ RESET VALUE(0b101) から 0b111 に変更します。
    { 0x30, 0xf1, 0xff }, // ILIM[6:4] のみ RESET VALUE(0b101) から 0b111 に変更します。
    { 0x31, 0xf1, 0xff }, // ILIM[6:4] のみ RESET VALUE(0b101) から 0b111 に変更します。
    { 0x32, 0xf1, 0xff }, // ILIM[6:4] のみ RESET VALUE(0b101) から 0b111 に変更します。
    { 0x33, 0x22, 0x77 }, // NSBG-7537, SIGLO-72587: B_SS_SR[2:0] を RESET VALUE(0b100)から 0b010 に変更し Soft Start Slew Rate を 5mV/us にします。
    { 0x34, 0x22, 0x77 }, // NSBG-7537, SIGLO-72587: B_RU_SR[2:0] を RESET VALUE(0b100)から 0b010 に変更し Ramp-Up Slew Rate を 5mV/us にします。
};

}} // namespace nnt::bpc
