﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nnt { namespace bpc {

class ExpectedEntry
{
    uint8_t address;
    uint8_t valueLow;
    uint8_t valueHigh;
    uint8_t mask;

public:
    // 初期化子リストは Siglo の C++ コーディング規約で明示的に許可されていない C++11 の機能であるため原則使用禁止ですが
    // 期待値リストを書きなおす手間を省くために採用しました。
    ExpectedEntry(uint8_t address, uint8_t value, uint8_t mask) NN_NOEXCEPT
    {
        this->address = address;
        this->valueLow = value;
        this->valueHigh = value;
        this->mask = mask;
    }

    ExpectedEntry(uint8_t address, uint8_t valueLow, uint8_t valueHigh, uint8_t mask) NN_NOEXCEPT
    {
        this->address = address;
        this->valueLow = valueLow;
        this->valueHigh = valueHigh;
        this->mask = mask;
    }

    bool CheckValue(uint8_t value) const NN_NOEXCEPT
    {
        auto maskedLow = this->valueLow & this->mask;
        auto maskedHigh = this->valueHigh & this->mask;
        auto maskedValue = value & this->mask;
        if ( maskedLow <= maskedValue && maskedValue <= maskedHigh )
        {
            return true;
        }

        NN_LOG("0x%02x:0x%02x should be in range of 0x%02x - 0x%02x(mask:0x%02x).\n", address, value, valueLow, valueHigh, mask);

        return false;
    }

    uint8_t GetAddress() const NN_NOEXCEPT
    {
        return address;
    }
};

}} // namespace nnt::bpc
