﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/btm/system/btm_SystemApi.h>
#include <nn/hid/hid_DebugPad.h>
#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_Thread.h>
#include <nn/settings/system/settings_BluetoothDevices.h>

#include <nnt/nntest.h>


/**
 * Bluetooth ペアリングが成功することをテストする
 * Test that Bluetooth pairing succeeds
 *
 * For automation purposes, this test should be run with a "Phidgets" board and modified JoyCon also attached to the PC
 */

TEST( BluetoothPairing, Basic )
{
    // Debug pad calls are causing asserts, http://spdlybra.nintendo.co.jp/jira/browse/SIGLONTD-4618 has details
    //nn::hid::DebugPadButtonSet prev;
    //nn::hid::DebugPadState state;
    bool controllerFound = false;

    nn::settings::system::BluetoothDevicesSettings mySettings[nn::settings::system::BluetoothDevicesSettingsCountMax];
    NN_ASSERT_NOT_NULL( mySettings );

    // nn::hid::InitializeDebugPad();
    NN_LOG("Clearing BluetoothDevicesSettings...");
    nn::settings::system::SetBluetoothDevicesSettings(nullptr, 0);
    NN_LOG("... cleared.\n");
    NN_LOG("Starting pairing...");
    nn::btm::system::StartGamepadPairing();
    //prev.Reset();

    int millisecondsSlept = 0;
    while( (millisecondsSlept < 120000) && !controllerFound )
    {
        // I'm leaving in the manual-assist debug controller code so that the test is easier to debug, though it's not needed for automation.
        //nn::hid::GetDebugPadState(&state);
        //if (state.buttons.Test<nn::hid::DebugPadButton::A>() == true &&
        //    prev.Test<nn::hid::DebugPadButton::A>() == false)
        //{
        //    NN_LOG("Pairing Started\n");
        //    nn::bluetooth::system::StartGamepadPairing();
        //}
        //if (state.buttons.Test<nn::hid::DebugPadButton::B>() == true &&
        //    prev.Test<nn::hid::DebugPadButton::B>() == false)
        //{
        //    NN_LOG("Pairing Canceled\n");
        //    nn::bluetooth::system::CancelGamepadPairing();
        //}
        //if (state.buttons.Test<nn::hid::DebugPadButton::X>() == true &&
        //    prev.Test<nn::hid::DebugPadButton::X>() == false)
        //{
        //    NN_LOG("Pairing Deleted\n");
        //    nn::bluetooth::system::ClearGamepadPairingDatabase();
        //}
        //prev = state.buttons;

        // Check to see if a controller has been paired with us yet.
        NN_LOG("Requesting Settings list..");
        auto count = nn::settings::system::GetBluetoothDevicesSettings(mySettings, nn::settings::system::BluetoothDevicesSettingsCountMax);
        NN_LOG("..retrieved. ");

        if (count > 0)
        {
            controllerFound = true;
            NN_LOG("%d PAIRED CONTROLLERS are detected. :D ", count);
            NN_LOG("Link Key Present? : %d ", mySettings[0].link_key_present);
            ASSERT_TRUE( mySettings[0].link_key_present > 0 );
            if ( 0 != mySettings[0].link_key_present )
                NN_LOG("Link key: [%2x:%2x:%2x:%2x:%2x:%2x:%2x:%2x:%2x:%2x:%2x:%2x:%2x:%2x:%2x:%2x]\n",mySettings[0].link_key[0],
                mySettings[0].link_key[1],mySettings[0].link_key[2],mySettings[0].link_key[3],mySettings[0].link_key[4],
                mySettings[0].link_key[5],mySettings[0].link_key[6],mySettings[0].link_key[7],mySettings[0].link_key[8],
                mySettings[0].link_key[9],mySettings[0].link_key[10],mySettings[0].link_key[11],mySettings[0].link_key[12],
                mySettings[0].link_key[13],mySettings[0].link_key[14],mySettings[0].link_key[15]);
        } else
        {
            NN_LOG("NO paired controllers were detected. :( \n");
        }

        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(1000));
        millisecondsSlept += 1000;
    }

    nn::btm::system::CancelGamepadPairing();

    // Now that we're done, verify whether we found a controller, and provide helpful debugging tips if we didn't.
    ASSERT_TRUE( controllerFound ) << "We should have found a controller paired to us, but didn't. Pairing failed! ... or the Carded controller's wires are loose in the phidgets relays, or the usb cable is disconnected. If you heard clacking sounds, the relays are working.";

    if ( controllerFound ) NN_LOG("... paired.\n");
}
