﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <cstdio>

#include <nnt/nntest.h>
#include <nn/nn_Log.h>

#include <nn/os.h>
#include <nn/os/os_SystemEventTypes.h>
#include <nn/settings/system/settings_BluetoothDevices.h>
#include <nn/bluetooth/bluetooth_Api.h>
#include <nn/bluetooth/bluetooth_TypesHal.h>

#include "../Common/testBluetooth_TargetDevices.h"


class BondingTest : public testing::Test
{
public:
    static void SetUpTestCase();
    static void TearDownTestCase();
};

namespace BondingTestSpace
{

    enum EventType
    {
        EVENTTYPE_FROM_CORE = 1,
        EVENTTYPE_FROM_HID
    };

    void WaitDeviceFoundCallback(nn::bluetooth::BluetoothAddress* pFoundAddr, nn::bluetooth::BluetoothName* pFoundName);
    char* BdaddrToString(const nn::bluetooth::BluetoothAddress bdaddr);
    void PrintEventInfo(nn::bluetooth::EventType eventType, const uint8_t buffer[]);
    void PrintEventInfo(nn::bluetooth::HidEventType eventType, const uint8_t buffer[]);

}
