﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nnt/nntest.h>

#include "../Common/testBle_Common.h"
#include "../Common/testBle_ScanCommon.h"

#include <nn/bluetooth/bluetooth_LeApi.h>
#include <nn/bluetooth/bluetooth_BleScanParameterIdTestPeripheral.h>

//!< Radio Off 中、Scan Parameter を取得しようとすると、成功する
TEST(TestBleScan, GetScanParameterRadioOff)
{
    nnt::bluetooth::common::SetUp();
    nnt::bluetooth::scan::SetUp();

    nnt::bluetooth::common::EnableRadio(false);

    nn::bluetooth::BleAdvertisePacketParameter param;
    nn::bluetooth::GetBleScanParameter(&param, nn::bluetooth::BleScanParameterId_TestPeripheral);

    nnt::bluetooth::common::TearDown();
    nnt::bluetooth::scan::TearDown();
}

//!< Radio Off 中、Scan を開始しようとすると、nn::bluetooth::ResultBluetoothOff()
TEST(TestBleScan, StartScanRadioOff)
{
    nnt::bluetooth::common::SetUp();
    nnt::bluetooth::scan::SetUp();

    nnt::bluetooth::common::EnableRadio(false);

    nn::Result result = nn::ResultSuccess();

    nn::bluetooth::BleAdvertisePacketParameter bleDeviceParam;
    nn::bluetooth::GetBleScanParameter(&bleDeviceParam, nn::bluetooth::BleScanParameterId_TestPeripheral);

    while (NN_STATIC_CONDITION(true))
    {
        result = nn::bluetooth::StartBleScanGeneral(bleDeviceParam);

        if (nn::bluetooth::ResultSystemBusy().Includes(result) ||
            nn::bluetooth::ResultGeneralError().Includes(result))           // General Error は返さないようにしたい
        {
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(5));
        }
        else
        {
            break;
        }
    }

    EXPECT_TRUE(nn::bluetooth::ResultBluetoothOff().Includes(result));

    while (NN_STATIC_CONDITION(true))
    {
        result = nn::bluetooth::StartBleScanSmartDevice(nnt::bluetooth::scan::testPeripheralAdvUuid);

        if (nn::bluetooth::ResultSystemBusy().Includes(result) ||
            nn::bluetooth::ResultGeneralError().Includes(result))           // General Error は返さないようにしたい
        {
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(5));
        }
        else
        {
            break;
        }
    }

    EXPECT_TRUE(nn::bluetooth::ResultBluetoothOff().Includes(result));

    nnt::bluetooth::common::TearDown();
    nnt::bluetooth::scan::TearDown();
}
