﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/testBcat_Common.h"

#include <nn/bcat/service/bcat_ArchiveDownloader.h>
#include <nn/socket.h>

// MEMO: td1 環境で動作確認すること。

namespace
{
    const nn::ApplicationId AppId = {0x0100db60000a8000};
    const char* Passphrase = "e3ac0d7a05b67c3e228369dff4aba298c645e8bd356ae45ac4910fac93d20d13";
}

namespace
{
    nn::socket::ConfigDefaultWithMemory g_SocketConfigWithMemory;

    nn::Bit8 g_FileWorkBuffer[256 * 1024];
}

TEST(ArchiveDownloader, Initialize)
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::fs::MountHost("save", "C:\\siglo"));
}

TEST(ArchiveDownloader, Do)
{
    nn::nifm::Initialize();
    nn::socket::Initialize(g_SocketConfigWithMemory);

    nn::nifm::NetworkConnection connection;

    connection.SubmitRequestAndWait();

    EXPECT_TRUE(connection.IsAvailable());

    nn::bcat::service::ArchiveDownloader downloader;

    downloader.SetPath("save:/download.msgpack", "save:/download.msgpack.bafmeta");
    downloader.SetPassphrase(AppId, Passphrase);

    downloader.SetFileWorkBuffer(g_FileWorkBuffer, sizeof (g_FileWorkBuffer));

    ASSERT_RESULT_SUCCESS(downloader.Download("https://bcat-list-td1.cdn.nintendo.net/api/nx/v1/list/nx_data_0100db60000a8000"));
}
