﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/vi/fbshare/vi_SharedLayerWindowGfx.h>
#include <nns/gfx/gfx_GraphicsFramework.h>

namespace Graphics{

    class GraphicsFrameworkEx
        : public nns::gfx::GraphicsFramework
    {
    public:

        virtual void Initialize(
            const nns::gfx::GraphicsFramework::FrameworkInfo& info,
            nn::AlignedAllocateFunctionWithUserData pAllocateFunction,
            nn::FreeFunctionWithUserData pFreeFunction,
            void* pAllocateFunctionUserData
        ) NN_NOEXCEPT NN_OVERRIDE;

        virtual void Initialize(
            const nns::gfx::GraphicsFramework::FrameworkInfo& info
        ) NN_NOEXCEPT NN_OVERRIDE;

        virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE;

        void AcquireTextureEx(int bufferIndex) NN_NOEXCEPT;
        void QueuePresentTextureEx(int presentInterval) NN_NOEXCEPT;

        nn::vi::fbshare::SharedLayerWindowGfx* GetSharedLayerWindow() NN_NOEXCEPT
        {
            return &m_SharedWindow;
        }



    protected:
        nn::vi::fbshare::SharedLayerWindowGfx m_SharedWindow;
    };

}
