﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/vi/vi_Layer.h>

namespace nn{ namespace vi{ namespace fbshare{
    class SharedLayerWindowGfx;
}}}

namespace Graphics {

struct Rgba
{
    float r;
    float g;
    float b;
    float a;
};

// フレームワークモード
enum FrameworkMode
{
    // QueueFinish を使用する従来のフレームワーク。(AppletOption1 + QueueFinish())
    // 非推奨。
    FrameworkMode_QueueFinish,

    // QueueAcquireTexture を使用するフレームワーク。
    // 非推奨ではないが、WindowAcquireTexture を使用するフレームワークをより推奨。
    FrameworkMode_AppletOption1,    // NX と Generic で挙動が異なる

    // WindowAcquireTexture を使用するフレームワーク。
    // vsync の前にコマンドの提出を行い、提出後 vsync を待ってから GPU が処理を始める。( AppletOption3 )
    // GPU を vsync 直後から使用できる。
    FrameworkMode_DeferredExecution,    // NX と Generic で挙動が異なる

    // WindowAcquireTexture を使用するフレームワーク。
    // vsync 後にコマンドの提出を行い、提出後から GPU が処理を始める。( EPD Mode )
    // sead や cafe の実装と互換がある。
    FrameworkMode_DeferredSubmission,

    // 表示の遅延が最少となるフレームワーク。
    FrameworkMode_Immediate,
};

void InitializeGraphics( Rgba clearColor, std::string title, FrameworkMode frameworkMode, bool isPartialForeground );

nn::vi::Layer* GetViLayer();

void EnableLinearTextures(const char* name1, const char* name2);
void DisableLinearTextures();

void SetMessage( const char* pMessage );

char* GetLinearTextureBuffer( int index );
size_t GetLinearTextureSize( int index );
size_t GetLinearTextureWidth( int index );
size_t GetLinearTextureHeight( int index );

int GetObjectCount();
void SetObjectCount( int objectCount );
int GetLiteObjectCount();
void SetLiteObjectCount(int objectCount);

int GetSleepCount();
void SetSleepCount(int sleepCount);

void SetAudioStatus(bool isEnable);

void SetWaitPressHomeButtonMode();

void GraphicsRenderer();

void WaitVsync();

void FinalizeGraphics();

nn::vi::fbshare::SharedLayerWindowGfx* GetSharedLayerWindow();

} // Graphics
