﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/account/account_ApiForSystemServices.h>
#include <nn/account/account_ApiPrivate.h>

#include <cstring>

#include <nn/nn_Log.h>
#include <nnt.h>

#define NNT_ACCOUNT_ENABLE_CHECK_DIGIT

#if defined(NNT_ACCOUNT_ENABLE_CHECK_DIGIT)

TEST(AccountCheckDigit, NetworkServiceAccount)
{
    struct TestCase
    {
        nn::account::NetworkServiceAccountId nsaId;
        int checkDigit;
        char code[27];
    };

    const TestCase tests[] = {
        {{0x0000000000000000ull}, 0}, // "0000-0000-0000-0000-0000-0"
        {{0x0000000000000001ull}, 7}, // "0000-0000-0000-0000-0001-7"
        {{0x000000000000000aull}, 9}, // "0000-0000-0000-0000-0010-9"
        {{0x000000000000000dull}, 0}, // "0000-0000-0000-0000-0013-0"
        {{0x28e837c5cb41dc3eull}, 3}, // "0294-7667-2787-7216-5694-3"
        {{0xfdfd3a7c3e40f98bull}, 6}, // "1830-1848-7659-9836-5067-6"
        {{0x0a213217f032e8b9ull}, 7}, // "0072-9919-6930-0623-5833-7"
        {{0x98f56903cee3fceeull}, 4}, // "1102-1831-1281-3602-3278-4"
        {{0x8ad330133b0725acull}, 8}, // "1000-3392-0564-7283-9596-8"
        {{0x0ea2062afd5fe9eeull}, 8}, // "0105-4412-0444-6743-1918-8"
        {{0xa1abd7f3042ae12full}, 0}, // "1164-9642-2998-7086-3663-0"
        {{0x6c6f1e45458246e8ull}, 6}, // "0781-3497-1613-7884-2344-6"
        {{0xd79e62976f604366ull}, 4}, // "1553-6964-1670-2295-3318-4"
        {{0xe8035e3725df4a19ull}, 5}, // "1671-8309-8326-8101-5833-5"
        {{0x6c53702c050d3513ull}, 1}, // "0780-5705-9135-2882-5107-1"
        {{0xa7d08ac58a5cf6f8ull}, 9}, // "1209-2317-5805-2432-0504-9"
    };
    for (const auto& test : tests)
    {
        // チェックディジットの検証
        auto checkDigit = nn::account::CalculateCheckDigit(test.nsaId);

        NN_LOG("nsaId= 0x%016llx, checkDigit= %d\n", test.nsaId.id, checkDigit);
        EXPECT_EQ(test.checkDigit, checkDigit);
    }
}

#endif
