﻿# coding: utf-8
from System.IO import *
from System.Text import *

import clr
clr.AddReference("PresentationFramework")
from System.Windows import *

# シェーダが割り当てられていないモデルの一覧を .csv ファイルに保存します。
# モデル一覧を出力した場合にのみ、ダイアログを表示します。
def Filter(target):
	target.Result = ""

	# material_shader_assign が存在するかのチェック
	error_item = ""

	for material in target.Document.SelectNodes(
		"/nw4f_3dif/model/material_array/material"):
		material_shader_assign = material.SelectSingleNode("shader_assign")
		if material_shader_assign == None:
			error_item += material.GetAttribute("name") + " "

	if error_item != "":
		error_message = "マテリアルにシェーダが割り当てられていません"
		step = "3DEditor でマテリアルにシェーダを割り当ててください"
		target.Result += "\"%s\",\"%s\",\"%s\",\"%s\",\"%s\"\r\n" % (
			target.FileName, step, error_message, error_item, target.FullPath)


def PostFilter(targets):
	result = ""
	for target in targets:
		result += target.Result

	if result != "":
		result = "\"ファイル名\",\"対応策\",\"エラー内容\",\"対象\",\"フルパス\"\r\n" + result
		File.WriteAllText(ScriptArgument, result, Encoding.GetEncoding("Shift_JIS"));
		MessageBox.Show(
			"モデルファイルに問題があります。\r\n%s\r\nを確認してください" % (ScriptArgument),
			"エラー",
			MessageBoxButton.OK, MessageBoxImage.Error)
