﻿# coding: utf-8
# モデルやアニメーションの量子化設定を削除します。
def Filter(target):
	for process_log in target.Document.SelectNodes(
		"//process_log[@process = \"quantization_analysis\"]"):
		process_log_array = process_log.ParentNode
		process_log_array.RemoveChild(process_log)
		if process_log_array.ChildNodes.Count == 0:
			process_log_array.ParentNode.RemoveChild(process_log_array)

	for quantize_type in target.Document.SelectNodes("//@quantize_type"):
		quantize_type.Value = "none"

	for hermite_curve in target.Document.SelectNodes("//hermite_curve"):
		ResetCurve(hermite_curve)
	for linear_curve in target.Document.SelectNodes("//linear_curve"):
		ResetCurve(linear_curve)
	for step_curve in target.Document.SelectNodes("//step_curve"):
		ResetCurve(step_curve)

	target.Write()

def ResetCurve(curve):
	curve.SetAttribute("frame_type", "none")
	curve.SetAttribute("key_type", "none")
	curve.SetAttribute("scale", "1")
	curve.SetAttribute("offset", "0")
