# coding: utf-8
# マテリアル名を変更するサンプルです。
def Filter(target):
	args = ScriptArgument.split(",")
	if len(args) < 2:
		Result = False
		return

	old_material_name = args[0].strip()
	new_material_name = args[1].strip()

	for mat in target.Document.SelectNodes("//material"):
		if mat.GetAttribute("name") == old_material_name:
			mat.SetAttribute("name", new_material_name)
			break

	for shape_info in target.Document.SelectNodes("//shape_info"):
		if shape_info.GetAttribute("mat_name") == old_material_name:
			shape_info.SetAttribute("mat_name", new_material_name)

	target.Write()
