﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

layout(std140, binding = 1) uniform Model
{
    uniform mat4 u_userMatrix;
    uniform vec4 u_color0;
    uniform vec4 u_color1;
    uniform vec2 u_uv_src;
    uniform vec2 u_uv_size;
    uniform vec4 u_layer;
    float rate;
};

layout( std140, binding = 2 ) uniform UserEffectParams
{
    vec4	uWeight0;
    vec4    uWeight1;
    int		uTextureWidth;
    int		uTextureHeight;
};

layout( binding = 0 ) uniform sampler2D uTexture0;

layout( location = 0 ) in vec4 vTexCoord;

out vec4 o_Color;

void main()
{
#if GAUSSIAN_BLUR_DIRECTION == 0
    float pixelUvScale = 1.0 / uTextureWidth;

    o_Color = texture(uTexture0, vec2(vTexCoord.s, vTexCoord.t                     )) * uWeight0.x;
    o_Color += texture(uTexture0, vec2(vTexCoord.s + pixelUvScale * 1.0, vTexCoord.t)) * uWeight0.y +
               texture(uTexture0, vec2(vTexCoord.s - pixelUvScale * 1.0, vTexCoord.t)) * uWeight0.y;
    o_Color += texture(uTexture0, vec2(vTexCoord.s + pixelUvScale * 2.0, vTexCoord.t)) * uWeight0.z +
               texture(uTexture0, vec2(vTexCoord.s - pixelUvScale * 2.0, vTexCoord.t)) * uWeight0.z;
    o_Color += texture(uTexture0, vec2(vTexCoord.s + pixelUvScale * 3.0, vTexCoord.t)) * uWeight0.w +
               texture(uTexture0, vec2(vTexCoord.s - pixelUvScale * 3.0, vTexCoord.t)) * uWeight0.w;
    o_Color += texture(uTexture0, vec2(vTexCoord.s + pixelUvScale * 4.0, vTexCoord.t)) * uWeight1.x +
               texture(uTexture0, vec2(vTexCoord.s - pixelUvScale * 4.0, vTexCoord.t)) * uWeight1.x;
    o_Color += texture(uTexture0, vec2(vTexCoord.s + pixelUvScale * 5.0, vTexCoord.t)) * uWeight1.y +
               texture(uTexture0, vec2(vTexCoord.s - pixelUvScale * 5.0, vTexCoord.t)) * uWeight1.y;
#elif GAUSSIAN_BLUR_DIRECTION == 1
    float pixelUvScale = 1.0 / uTextureHeight;

    o_Color = texture(uTexture0, vec2(vTexCoord.s, vTexCoord.t                     )) * uWeight0.x;
    o_Color += texture(uTexture0, vec2(vTexCoord.s, vTexCoord.t + pixelUvScale * 1.0)) * uWeight0.y +
               texture(uTexture0, vec2(vTexCoord.s, vTexCoord.t - pixelUvScale * 1.0)) * uWeight0.y;
    o_Color += texture(uTexture0, vec2(vTexCoord.s, vTexCoord.t + pixelUvScale * 2.0)) * uWeight0.z +
               texture(uTexture0, vec2(vTexCoord.s, vTexCoord.t - pixelUvScale * 2.0)) * uWeight0.z;
    o_Color += texture(uTexture0, vec2(vTexCoord.s, vTexCoord.t + pixelUvScale * 3.0)) * uWeight0.w +
               texture(uTexture0, vec2(vTexCoord.s, vTexCoord.t - pixelUvScale * 3.0)) * uWeight0.w;
    o_Color += texture(uTexture0, vec2(vTexCoord.s, vTexCoord.t + pixelUvScale * 4.0)) * uWeight1.x +
               texture(uTexture0, vec2(vTexCoord.s, vTexCoord.t - pixelUvScale * 4.0)) * uWeight1.x;
    o_Color += texture(uTexture0, vec2(vTexCoord.s, vTexCoord.t + pixelUvScale * 5.0)) * uWeight1.y +
               texture(uTexture0, vec2(vTexCoord.s, vTexCoord.t - pixelUvScale * 5.0)) * uWeight1.y;
#endif
}

