﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/nn_Macro.h>
#include <nn/hid/hid_Mouse.h>
#include <nns/hid/hid_MouseAsset.h>

namespace nns { namespace hid {

MouseAsset::MouseAsset(ControllerManager* pManager) NN_NOEXCEPT
    : DeviceAsset(pManager)
    , m_SamplingNumber(-1)
{
    NN_ASSERT_NOT_NULL(pManager);
}

MouseAsset::~MouseAsset() NN_NOEXCEPT {}

void MouseAsset::Initialize() NN_NOEXCEPT
{
    // マウスを初期化します。
    nn::hid::InitializeMouse();
}

void MouseAsset::Update() NN_NOEXCEPT
{
    // 前回のマウスの入力状態を破棄します。
    m_States.clear();

    // マウスの入力状態を取得します。
    const int count = nn::hid::GetMouseStates(
        m_TemporaryStates, nn::hid::MouseStateCountMax);

    // 新たに観測された入力状態を記録します。
    for (int i = 0; i < count; ++i)
    {
        const nn::hid::MouseState& state = m_TemporaryStates[i];

        if (state.samplingNumber <= m_SamplingNumber)
        {
            break;
        }

        m_States.push_back(state);
    }

    // 最新のサンプリング番号を更新します。
    if (count > 0)
    {
        m_SamplingNumber = m_TemporaryStates[0].samplingNumber;
    }
}

}} // namespace nns::hid
