﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/nn_Macro.h>
#include <nn/hid/hid_DebugPad.h>
#include <nns/hid/hid_DebugPadAsset.h>

namespace nns { namespace hid {

DebugPadAsset::DebugPadAsset(ControllerManager* pManager) NN_NOEXCEPT
    : DeviceAsset(pManager)
{
    NN_ASSERT_NOT_NULL(pManager);
}

DebugPadAsset::~DebugPadAsset() NN_NOEXCEPT {}

void DebugPadAsset::Initialize() NN_NOEXCEPT
{
    // DebugPad を初期化します。
    nn::hid::InitializeDebugPad();
}

void DebugPadAsset::Update() NN_NOEXCEPT
{
    // DebugPad の入力状態を取得します。
    nn::hid::GetDebugPadState(&m_State);
}

}} // namespace nns::hid
