﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#extension GL_ARB_gpu_shader5 : enable

//------------------------------------------------------------------------------
// Shading Mode
//------------------------------------------------------------------------------
#define SHADING_MODE_VERTEX_COLOR          ( 0 )
#define SHADING_MODE_SOLID_COLOR           ( 1 )
#define SHADING_MODE_TEXTURE               ( 2 )
#define SHADING_MODE_TEXTURE_ARRAY         ( 3 )
#define SHADING_MODE_TEXTURE_CUBEMAP       ( 4 )

//------------------------------------------------------------------------------
// シェーダステージ固有の変数定義です。
//------------------------------------------------------------------------------
// 頂点シェーダ
#if NN_GFX_VERTEX_SHADER

out gl_PerVertex
{
    vec4 gl_Position;
};

layout( std140, binding = 0 ) uniform View
{
    mat4 u_mvp;
};

#endif

// ピクセルシェーダ
#if NN_GFX_PIXEL_SHADER

#endif

//------------------------------------------------------------------------------
// シェーダステージ共通のブロック定義です。
//------------------------------------------------------------------------------
layout( std140, binding = 1 ) uniform Model
{
    uniform mat4 u_userMatrix;
    uniform vec4 u_color;
    uniform vec2 u_uv_src;
    uniform vec2 u_uv_size;
    uniform vec4 u_layer;      // x: テクスチャ：LOD、テクスチャ配列：レイヤー
    float rate;
};

