﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/os/os_TransferMemory.h>
#include <nn/os/os_SharedMemory.h>
#include <nn/os/os_SystemEvent.h>
#include <nns/gfx0/gfx0_IGfx0Driver.sfdl.h>

#include "gfx0_DriverSample.h"

namespace nns { namespace gfx0 {

//-----------------------------------------------------------------------------
//  IGfx0Driver の実装用クラス
//
//  IGfx0Driver を直接継承はせず、各関数のシグネチャだけ合わせる。
//-----------------------------------------------------------------------------

class Gfx0DriverImpl
{
private:
    Gfx0DriverSample    m_DriverSample;

public:
    nn::Result WaitServerReady() NN_NOEXCEPT;
    nn::Result AddValue(nn::sf::Out<int32_t> pOut, int32_t x, int32_t y) NN_NOEXCEPT;

    // These functions are used in gfx0client/server skeleton code.
    nn::Result AttachTransferMemoryImpl(nn::sf::NativeHandle sfHandle, uint64_t size) NN_NOEXCEPT;
    nn::Result AttachDeviceMemory(nn::sf::NativeHandle sfHandle, uint64_t address, uint64_t size) NN_NOEXCEPT;
    nn::Result QuerySharedMemoryImpl(nn::sf::Out<nn::sf::NativeHandle> pOutHandle, nn::sf::Out<uint64_t> pOutSize) NN_NOEXCEPT;
    nn::Result QuerySystemEventImpl(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT;
    void AdvanceDemo() NN_NOEXCEPT;
};

//-----------------------------------------------------------------------------

}}  // namespace nns::gfx0

