﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <nn/TargetConfigs/build_Base.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/dd.h>

#include "display0_DriverImpl.h"

namespace nns { namespace display0 {

//-----------------------------------------------------------------------------
//  ディスプレイドライバの処理を開始します。
//
void Display0DriverImpl::StartDisplay0(nn::sf::NativeHandle systemEventHandle) NN_NOEXCEPT
{
    m_DriverSample.Initialize( systemEventHandle.GetOsHandle(),
                               systemEventHandle.IsManaged() );
    systemEventHandle.Detach();
}


//-----------------------------------------------------------------------------
//  ディスプレイドライバの処理を停止します。
//
void Display0DriverImpl::StopDisplay0() NN_NOEXCEPT
{
    m_DriverSample.Finalize();
}

//-----------------------------------------------------------------------------

}}  // namespace nns::display0

