﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/wlan/wlan_InfraApi.h>
#include "BaseScene.h"

// タイトル画面
class SceneTitle : public BaseScene {

public :
    SceneTitle(
            ISceneChanger* changer,
            WirelessData* pDistributor
            ) NN_NOEXCEPT;
    void Initialize() NN_NOEXCEPT override;
    void Finalize() override;
    void Update() NN_NOEXCEPT override;
    void Draw(
            GraphicsSystem* pGraphicsSystem,
            FontSystem* pFontSystem
            ) NN_NOEXCEPT override;

private :
    static const int ITEM_NUM = 3;
    static const int MY_INITIAL_X = INITIAL_X + (FONT_SIZE * 1);
    static const int MY_INITIAL_Y = INITIAL_Y + (FONT_SIZE * 3);
    int m_curY;
    int16_t m_allowedChannels[nn::wlan::WirelessChannelsCountMax];
    uint32_t m_allowedChannelCount;
};
