﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <iomanip>
#include "Common.h"
#include "TextWriter.h"

namespace WlanTest {

/*
  TextWriterDecorator
*/

TextWriterDecorator::TextWriterDecorator(TextWriter& writer)
{
    m_Writer = &writer;
}

TextWriterDecorator::~TextWriterDecorator()
{
}

bool TextWriterDecorator::Write(const std::string& str)
{
    return m_Writer->Write(str);
}


/*
  TimeWriter
*/

TimeWriter::TimeWriter(TextWriter& writer) : TextWriterDecorator(writer)
{
    Reset();
    m_NeedWriteTime = true;
}

TimeWriter::~TimeWriter()
{
}

//! 文字列を書き込みます
bool TimeWriter::Write(const std::string& str)
{
    bool result;

    if( m_NeedWriteTime )
    {
        nn::os::Tick now = nn::os::GetSystemTick();
        std::ostringstream oss;
        oss << "[" << setw(9) << (now - m_Start).ToTimeSpan().GetMilliSeconds() << "] " << str;
        result = m_Writer->Write(oss.str());
    }
    else
    {
        result = m_Writer->Write(str);
    }

    if( str.back() == '\n' )
    {
        m_NeedWriteTime = true;
    }
    else
    {
        m_NeedWriteTime = false;
    }

    return result;
}

void TimeWriter::Reset()
{
    m_Start = nn::os::GetSystemTick();
}



}    // WlanTest
