﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ModelViewer.h"

namespace WlanTest {

string GenerateTitle(const string& title, const uint32_t size, const char sep)
{
    uint32_t num = 0;
    if( size > title.size() )
    {
        num = size - title.size();
    }
    return title + string(num, ' ') + sep + " ";
}

void SetUnitConfiguration(Label* pLabel, const string& text, const uint32_t& x, const uint32_t& y)
{
    SetUnitConfiguration(pLabel, text);
    pLabel->X = x;
    pLabel->Y = y;
}

void SetUnitConfiguration(Label* pLabel, const string& text)
{
    SetUnitConfiguration(pLabel);
    pLabel->Text = text;
    pLabel->FitSize();
}

void SetUnitConfiguration(Label* pLabel)
{
    pLabel->FontWidth *= 0.6;
    pLabel->FontHeight *= 0.6;
    pLabel->FixedWidth *= 0.6;
}

const char MultiDataSinkSwitchableViewer::CaptionText[PageName_Count][CaptionLength] =
{
    //"-------- -------- ----- ----- ------"
    "                          TTL       \n"
    " RxCount   RxLost   PLR   PLR   Thpt",

    //"------- -----"
    "  AvgRx MaxRx\n"
    "  Intvl Intvl"
};

const char MultiAfSinkSwitchableViewer::CaptionText[PageName_Count][CaptionLength] =
{
    //"-------- -------- ----- ------"
    "                              \n"
    " RxCount   RxLost   PLR   Thpt",

    //"------- -----"
    "  AvgRx MaxRx\n"
    "  Intvl Intvl"
};

const char MultiNdhpSinkSwitchableViewer::CaptionText[PageName_Count][CaptionLength] =
{
    //"-------- -------- ----- ------ ----"
    "                                Avg\n"
    " RxCount   RxLost   PLR   Thpt RSSI",

    //"------- ----- ----------------"
    "  AvgRx MaxRx                 \n"
    "  Intvl Intvl             Hash"
};


}
