﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Common.h"
#include "Log.h"

using namespace std;

namespace WlanTest {

/*---------------------------------------------------------------------------
　　　　　PacketLogger
---------------------------------------------------------------------------*/

PacketLogger* PacketLogger::m_pLogger = nullptr;
bool PacketLogger::m_IsEnabled = false;

PacketLogger::PacketLogger()
{
    m_pCardWriter = new CardWriter();
    m_pTimeWriter = new TimeWriter(*m_pCardWriter);
}

PacketLogger::~PacketLogger()
{
    delete m_pCardWriter;
    delete m_pTimeWriter;
    delete m_pLogger;
}

PacketLogger& PacketLogger::GetInstance()
{
    if( m_pLogger == nullptr )
    {
        m_pLogger = new PacketLogger();
    }

    return *m_pLogger;
}

bool PacketLogger::Initialize(const string& dirPath, const string& filePrefix)
{
    if( !m_IsEnabled )
    {
        return false;
    }

    return m_pCardWriter->Initialize(dirPath, filePrefix);
}

void PacketLogger::Finalize()
{
    if( !m_IsEnabled )
    {
        return;
    }

    m_pCardWriter->Finalize();
}

bool PacketLogger::Write(const string& str)
{
    if( !m_IsEnabled )
    {
        return false;
    }

    bool result = m_pTimeWriter->Write(str);
    if( !result )
    {
        // 書き込みに失敗したらそれ以上の書き込みは行わない (SD カードなしの状態で nn::fs::GetFileSize() を 2 回行うと落ちるため)
        m_pCardWriter->Finalize();
    }

    return result;
}

bool PacketLogger::IsEnabled()
{
    return m_IsEnabled;
}

void PacketLogger::EnableLog()
{
    m_IsEnabled = true;
}

void PacketLogger::DisableLog()
{
    m_IsEnabled = false;
}

}    // WlanTest
