﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace WlanTest {

/*!--------------------------------------------------------------------------*
  @brief        リングバッファ

 *---------------------------------------------------------------------------*/
template <typename Datatype>
class RingBuffer {
public:
    NN_IMPLICIT RingBuffer(int size);
    virtual ~RingBuffer();

    int GetSize();
    void SetValue(Datatype data);
    void Clear();
    Datatype operator[](int i);

private:
    Datatype* m_Buffer;
    int m_Size;
    int m_Next;
    bool Overwriting;
};


/*!--------------------------------------------------------------------------*
  Name:	        RingBuffer::RingBuffer

  @brief        コンストラクタです。

  @return       なし

 *---------------------------------------------------------------------------*/
template <typename Datatype>
RingBuffer<Datatype>::RingBuffer(int size) {
    m_Size = size;
    m_Buffer = new Datatype[size];
    Overwriting = false;
    m_Next = 0;
}

/*!--------------------------------------------------------------------------*
  Name:         RingBuffer::~RingBuffer

  @brief        デストラクタです。

  @return       なし

 *---------------------------------------------------------------------------*/
template <typename Datatype>
RingBuffer<Datatype>::~RingBuffer()
{
    delete[] m_Buffer;
}

/*!--------------------------------------------------------------------------*
  Name:         RingBuffer::Celar

  @brief        クリアします。

  @return       なし

 *---------------------------------------------------------------------------*/
template <typename Datatype>
void RingBuffer<Datatype>::Clear()
{
    Overwriting = false;
    m_Next = 0;
}



/*!--------------------------------------------------------------------------*
  Name:         RingBuffer::GetSize

  @brief        サイズを取得します。

  @return       なし

 *---------------------------------------------------------------------------*/
template <typename Datatype>
int RingBuffer<Datatype>::GetSize()
{
//    NN_LOG("RingBuffer::GetSize() was called.\n");

    if(Overwriting)
    {
        return m_Size;
    }
    else
    {
        return m_Next;
    }
}


/*!--------------------------------------------------------------------------*
  Name:         RingBuffer::SetValue

  @brief        値をセットします。

  @return       なし

 *---------------------------------------------------------------------------*/
template <typename Datatype>
void RingBuffer<Datatype>::SetValue(Datatype data)
{
    //NN_LOG("RingBuffer::SetValue() was called.\n");

    m_Buffer[m_Next] = data;
    m_Next = (m_Next + 1) % m_Size;
    if(m_Next == 0)
    {
        Overwriting = true;
    }
}

/*!--------------------------------------------------------------------------*
  Name:         RingBuffer::operator[]

  @brief        operator[]

  @return

 *---------------------------------------------------------------------------*/
template <typename Datatype>
Datatype RingBuffer<Datatype>::operator[](int i)
{
    int start = 0;
    if(Overwriting)
    {
        start = m_Next;
    }
    return m_Buffer[(start + i) % m_Size];
}



}
