﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Program.h"
#include "Tester.h"

namespace WlanTest {


    enum FunctionId
    {
        FUNCITON_ID_DEFAULT = 0,
        FUNCTION_ID_LOCAL_MASTER,
        FUNCTION_ID_LOCAL_CLIENT,
        FUNCTION_ID_LOCAL_AUDIENCE,
        FUNCTION_ID_LOCAL_SCANNER,
        FUNCTION_ID_LOCAL_MEASURER,
        FUNCTION_ID_INFRA_CLIENT,
        FUNCTION_ID_LOG_SETTING
    };

    class LocalMasterConnectivityFunction : public Program
    {
    protected:
        Master                 m_Node;
    MasterController       m_Controller;
    NodeViewer             m_Viewer;
    //TargetStatisticsViewer m_StatisticsViewer;

    DataGenerator           m_Generator;
    DataGeneratorController m_GeneratorController;

    MultiDataSink                       m_Sink;
    MultiDataSinkViewer                 m_SinkViewer;
    //BurstStatisticsViewer               m_BurstViewer;
    ReceiveEventHandler(MultiDataSink) * m_pHandler;

    SwitchablePage    m_SwitchablePage;
    Page*             m_pPage;

public:
    MasterMode()
    {
        m_ProgramId = PROGRAM_ID_LOCAL_MASTER;
        m_pHandler = new ReceiveEventHandler(MultiDataSink)(m_Sink, &MultiDataSink::Sink);
        InitializeComponent();
    }

    virtual ~MasterMode()
    {
        delete m_pHandler;
    }

    virtual void InitializeComponent()
    {
        m_Controller.SetTarget(m_Node);
        m_Viewer.SetTarget(m_Node);
        //m_StatisticsViewer.SetTarget(m_Node);

        m_Generator.SetTarget(m_Node);
        m_GeneratorController.SetTarget(m_Generator);
        m_SinkViewer.SetTarget(m_Sink);
        //m_BurstViewer.SetTarget(m_Sink);
        m_Node.SetReceiveEventHandler(*m_pHandler);

        m_SwitchablePage.Width = Display::GetInstance().GetWidth();
        m_SwitchablePage.AddPage("Node Controller", m_Controller);
        m_SwitchablePage.AddPage("Generator Controller", m_GeneratorController);
        //m_SwitchablePage.AddPage("Statistics Viewer", m_StatisticsViewer);
        m_SwitchablePage.AddPage("Node Viewer", m_Viewer);
        m_SwitchablePage.AddPage("Sink Viewer", m_SinkViewer);
        //m_SwitchablePage.AddPage("BurstStatistics Viewer", m_BurstViewer);
        //m_SwitchablePage.AddPage("Console", LogManager::GetInstance().GetLogPage());

        //m_pPage = &LogManager::GetInstance().GetLogPage();

        m_Controller.SetDataGeneratorController(m_GeneratorController);
    }

    virtual void Execute()
    {
        Pad& pad = Pad::GetInstance();

        m_SwitchablePage.Show( Display::GetInstance() );
        m_pPage->Show( Display::GetInstance() );

        if( pad.IsTrigger(Button::X) )
        {
            m_pPage = &(m_SwitchablePage.GetCurrentPage());
        }
    }

    virtual void Exit()
    {
        m_Controller.Stop();
    }

    const map<uint64_t, string>& GetSources()
    {
        return m_Sink.GetSources();
    }

    const map<uint64_t, WlanTest::MultiDataSink::Statistics*>& GetStatistics()
    {
        return m_Sink.GetStatistics();
    }

    bool IsBeaconActive()
    {
        return !m_Controller.IsIdle();
    }

    bool IsGeneratorActive()
    {
        return !m_Generator.IsIdle();
    }

private:
    MasterMode(const MasterMode& masterMode);
    MasterMode& operator=(const MasterMode& masterMode);

    };


} // WlanTest
