﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace WlanTest {

class WitArg
{
public :

    static const int TEST_NAME_SIZE = 64;
    static const int ROLE_NAME_SIZE = 32;
    static const int INPUT_FILE_NAME_SIZE = 128;
    static const int ARG_SIZE_MAX = 10;
    static const int ARG_STRING_LENGTH_MAX = 255;

private :

    int      m_Argc;
    char     m_Argv[ARG_SIZE_MAX][ARG_STRING_LENGTH_MAX];

    char     m_TestName[TEST_NAME_SIZE];
    int      m_TestId;

    char     m_RoleName[ROLE_NAME_SIZE];
    int      m_RoleId;

    char     m_InputFile[INPUT_FILE_NAME_SIZE];

public :

    WitArg();
    virtual ~WitArg();

    void Initialize();
    void Initialize(int argc, char argv[ARG_SIZE_MAX][ARG_STRING_LENGTH_MAX]);
    bool Parse();

    int GetTestId(){ return m_TestId; }
    int GetRoleId(){ return m_RoleId; }
    char* GetInputFilePath(){ return m_InputFile; }
};

}
