﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/wlan/wlan_Types.h>
#include "BaseScene.h"
#include "FsSdCard.h"

// タイトル画面
class SceneLoggingCh : public BaseScene {
    enum Menu {
        Menu_Channel = 0,
        Menu_ScanTime,
        Menu_MeasureInterval,
        Menu_End
    };
    enum SubMenu {
        SubMenu_MA1min = 0,
        SubMenu_MA5min,
        SubMenu_MA10min,
        SubMenu_MA25min,
        SubMenu_TimeScale,
        SubMenu_End
    };
    enum Page {
        Page_Setting = 0,
        Page_Noise,
        Page_Txop,
        Page_End
    };
    // 移動平均線の計算期間
    enum MAWindow {
        MAWindow_1min = 0,
        MAWindow_5min,
        MAWindow_10min,
        MAWindow_25min,
        MAWindow_End
    };

private :
    static constexpr float DISPLAY_X = 100.f;
    static constexpr float DISPLAY_Y = 60.f;
    static constexpr float DISPLAY_UNIT_W = 5.f;
    static constexpr float DISPLAY_UNIT_H = 5.f;
    static const int POINTABLE_COUNTS = static_cast<int>((SCREEN_WIDTH - (2 * DISPLAY_X)) / DISPLAY_UNIT_W) + 1;
    static const int SAVE_INTERVAL = 10;  // 計測結果自動保存インターバル[分]
    struct loggingInfo {
        uint64_t noiseSum;  // 直近一定カウント分の和
        uint64_t txopSum;   // 直近一定カウント分の和
        uint64_t count;
        int measureInterval;
        nn::wlan::ScanParameters scanParam;
    };
    static loggingInfo m_logInfo;

    struct unitTimeStats {
        unitTimeStats *prev;
        unitTimeStats *next;
        nn::time::CalendarTime time;  // 測定時刻
        int8_t noise;
        uint8_t txop;
        uint64_t id;  // ノード番号
    };
    unitTimeStats* m_pTopUTS;  // 先頭ノード
    unitTimeStats* m_pDispLastUTS;  // 画面に表示中されているうちの最新ノード
    unitTimeStats* m_pDispFirstUTS;  // 画面に表示中されているうちの最古ノード
    unitTimeStats* m_pPointedUTS;  // 詳細表示中のノード
    static unitTimeStats* m_pLastUTS; // 最新ノード（計測の度に更新される）
    int16_t m_allowedChannels[nn::wlan::WirelessChannelsCountMax];
    uint32_t m_allowedChannelCount;
    uint8_t m_curChId; // スキャンチャンネルをm_allowedChannels配列の添字に変換した値
    bool m_IsLastUTSPointed;  // 最新ノードに表示を追従させるかどうか
    bool m_IsPointedUTSDisplayed; // 詳細表示をONにするか
    bool m_IsMaDisplayed[MAWindow_End];

    nn::os::ThreadType m_measureThread;
    static bool m_measureExitFlag;
    static nn::wlan::ChannelStats m_stats[nn::wlan::WirelessChannelsCountMax + 1];
    static nn::os::MutexType m_mutex;

    int m_curMenu;
    int m_curPage;
    int m_curSubMenu;

    static FsSdCard m_SdWriter;

    nn::os::ThreadType m_saveThread;
    static bool m_saveExitFlag;
    static unitTimeStats* m_pSaveUTS;
    static char m_saveStr[30 * 1024];  // 10分ごとに書き込むテキスト（最大30KB）
    bool m_IsSdInserted;

    bool m_IsSubMenuOpened;  // 移動平均線の描画のON/OFFなどを行うメニュー表示フラグ

public :
    explicit SceneLoggingCh(ISceneChanger* changer) NN_NOEXCEPT;
    void Initialize() NN_NOEXCEPT override;
    void Finalize() override;
    void Update() NN_NOEXCEPT override;
    void Draw(GraphicTools* pTools) NN_NOEXCEPT override;
private :
    static void MeasureThreadFunc(void* arg) NN_NOEXCEPT;
    static void SaveResultsThreadFunc(void* arg) NN_NOEXCEPT;
    void StartMeasure() NN_NOEXCEPT;
    void StopMeasure() NN_NOEXCEPT;
    void DrawSetting(GraphicTools* pTools) NN_NOEXCEPT;
    void DrawLog(GraphicTools* pTools) NN_NOEXCEPT;
    // 移動平均線(Moving Average)を描画
    void DrawMa(GraphicTools* pTools) NN_NOEXCEPT;
    void DrawSubmenu(GraphicTools* pTools) NN_NOEXCEPT;
    int GetAverage(unitTimeStats* pHead, MAWindow window) NN_NOEXCEPT;
};
