﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "BaseScene.h"

// タイトル画面
class SceneMasterSetting : public BaseScene
{
    enum InputItem {
        InputItem_Ssid,
        InputItem_Pw
    };

    enum SecurityItem {
        SecurityItem_Open,
        SecurityItem_StaticAes
    };

    enum curItem {
        curItem_Channel,
        curItem_hiddenSsid,
        curItem_inavtivePeriod,
        curItem_Ssid,
        curItem_SecurityMode,
        curItem_SecurityPw,
        curItem_contentsChangeInterval,
        curItem_Go,
        curItem_NumOfItem
    };

public :
    SceneMasterSetting(
            ISceneChanger* changer,
            WirelessData* pDistributor
            ) NN_NOEXCEPT;
    void Initialize() NN_NOEXCEPT override;
    void Finalize() override;
    void Update() NN_NOEXCEPT override;
    void Draw(
            GraphicsSystem* pGraphicsSystem,
            FontSystem* pFontSystem
            ) NN_NOEXCEPT override;
    void SetApplicationHeap(ApplicationHeap* pApplicationHeap) NN_NOEXCEPT;
private:
    void InputBySwkbd(char* initStr, char* pOutStr, InputItem item) NN_NOEXCEPT;

private :
    static const int MY_INITIAL_X = INITIAL_X + (FONT_SIZE * 2);
    static const int MY_INITIAL_Y = INITIAL_Y + (FONT_SIZE * 4);
    int m_curY;

    // MasterParam
    nn::wlan::MasterBssParameters m_bssParam;
    WirelessData::PeriodicActionFrameParam m_afParam;
    char m_pwStr[64];

    // 入力間違いなどがあったときに画面に注意文を表示させる用文字列
    char m_commentStr[128];

    ApplicationHeap* m_pApplicationHeap;
};
